<?php
    $titles = __('error_titles', true);
    $bodies = __('error_bodies', true);

    $date_format = pjUtil::toBootstrapDate($tpl['option_arr']['o_date_format']);
    $months = __('months', true);
    ksort($months);
    $short_days = __('short_days', true);
?>
<div id="datePickerOptions" style="display:none;" data-wstart="<?php echo (int) $tpl['option_arr']['o_week_start']; ?>" data-format="<?php echo $date_format; ?>" data-months="<?php echo implode("_", $months);?>" data-days="<?php echo implode("_", $short_days);?>"></div>

<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-sm-12">
        <div class="row">
            <div class="col-lg-12 col-md-12 col-sm-12">
                <h2><?php echo __('infoModifyPricesTitle', true); ?></h2>
            </div>
        </div>
    </div>
</div>

<div class="row wrapper wrapper-content animated fadeInRight">
    <?php
        $error_code = $controller->_get->toString('err');
        if (!empty($error_code))
        {
            switch (true)
            {
                case in_array($error_code, array('AOMP01')):
                    ?>
                    <div class="alert alert-success">
                        <i class="fa fa-check m-r-xs"></i>
                        <strong><?php echo @$titles[$error_code]; ?></strong>
                        <?php echo @$bodies[$error_code]?>
                    </div>
                    <?php
                    break;
                case in_array($error_code, array('')):
                    ?>
                    <div class="alert alert-danger">
                        <i class="fa fa-exclamation-triangle m-r-xs"></i>
                        <strong><?php echo @$titles[$error_code]; ?></strong>
                        <?php echo @$bodies[$error_code]?>
                    </div>
                    <?php
                    break;
            }
        }
    ?>
    <div class="col-lg-12">
        <div class="ibox float-e-margins">
            <div class="ibox-content">
                <form action="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminOptions&amp;action=pjActionModifyPrices" method="post" class="form-horizontal" id="frmUpdateOptions">
                    <input type="hidden" name="save" value="1" />

                    <div class="table-responsive table-responsive-secondary">
                        <table class="table table-striped table-hover" id="tblModifyPrices">
                            <thead>
                            <tr>
                                <th><?php __('lblModifyPricesDateFrom'); ?></th>
                                <th><?php __('lblModifyPricesDateTo'); ?></th>
                                <th><?php __('lblModifyPricesLocation'); ?></th>
                                <th><?php __('lblModifyPricesType'); ?></th>
                                <th><?php __('lblModifyPricesPercent'); ?></th>
                                <th><?php __('lblModifyPricesIncreaseDecrease'); ?></th>
                                <th></th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php if (!empty($tpl['modify_prices'])): ?>
                                <?php foreach ($tpl['modify_prices'] as $modifyPrice): ?>
                                    <tr>
                                        <td>
                                            <div class="input-group">
                                                <input type="text" name="modify_prices[<?php echo $modifyPrice['id']; ?>][date_from]" value="<?php echo pjDateTime::formatDate($modifyPrice['date_from'], 'Y-m-d', $tpl['option_arr']['o_date_format']); ?>" class="form-control datepick required" data-wt="open" readonly="readonly" data-msg-required="<?php __('plugin_base_this_field_is_required');?>" data-msg-remote="<?php __('lblPickupWorkingTime');?>">
                                                <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                                            </div>
                                        </td>
                                        <td>
                                            <div class="input-group">
                                                <input type="text" name="modify_prices[<?php echo $modifyPrice['id']; ?>][date_to]" value="<?php echo pjDateTime::formatDate($modifyPrice['date_to'], 'Y-m-d', $tpl['option_arr']['o_date_format']); ?>" class="form-control datepick required" data-wt="open" readonly="readonly" data-msg-required="<?php __('plugin_base_this_field_is_required');?>" data-msg-remote="<?php __('lblPickupWorkingTime');?>">
                                                <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                                            </div>
                                        </td>
                                        <td>
                                            <select name="modify_prices[<?php echo $modifyPrice['id']; ?>][location_id]" class="form-control">
                                                <option value="0">-- <?php echo __('lblRequestsAllLocations'); ?> --</option>
                                                <?php if (!empty($tpl['locations'])): ?>
                                                    <?php foreach ($tpl['locations'] as $location): ?>
                                                        <option value="<?php echo $location['id']; ?>" <?php echo ($location['id'] == $modifyPrice['location_id']) ? 'selected' : ''; ?>><?php echo $location['name']; ?></option>
                                                    <?php endforeach; ?>
                                                <?php endif; ?>
                                            </select>
                                        </td>
                                        <td>
                                            <select name="modify_prices[<?php echo $modifyPrice['id']; ?>][type_id][]" class="form-control multiple" multiple required>
                                                <option value="0" <?php echo (in_array(0, $modifyPrice['type_id'])) ? 'selected' : ''; ?>>-- <?php echo __('lblRequestsAllTypes'); ?> --</option>
                                                <?php if (!empty($tpl['types'])): ?>
                                                    <?php foreach ($tpl['types'] as $type): ?>
                                                        <option value="<?php echo $type['id']; ?>" <?php echo (in_array($type['id'], $modifyPrice['type_id'])) ? 'selected' : ''; ?>><?php echo $type['name']; ?></option>
                                                    <?php endforeach; ?>
                                                <?php endif; ?>
                                            </select>
                                        </td>
                                        <td>
                                            <input type="text" class="form-control" name="modify_prices[<?php echo $modifyPrice['id']; ?>][percent]" value="<?php echo $modifyPrice['percent']; ?>">
                                        </td>
                                        <td>
                                            <select name="modify_prices[<?php echo $modifyPrice['id']; ?>][type]" class="form-control" required>
                                                <option value=""></option>
                                                <option value="increase" <?php echo ($modifyPrice['type'] == 'increase') ? 'selected' : ''; ?>><?php __('lblModifyPricesIncrease'); ?></option>
                                                <option value="decrease" <?php echo ($modifyPrice['type'] == 'decrease') ? 'selected' : ''; ?>><?php __('lblModifyPricesDecrease'); ?></option>
                                            </select>
                                        </td>
                                        <td class="text-center">
                                            <a href="javascript:;" class="btn btn-danger btn-outline btn-sm m-l-xs btnRemoveModifyPrice"><i class="fa fa-trash"></i></a>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            <?php else: ?>
                                <tr>
                                    <td>
                                        <div class="input-group">
                                            <input type="text" name="modify_prices[0][date_from]" value="" class="form-control datepick required" data-wt="open" readonly="readonly" data-msg-required="<?php __('plugin_base_this_field_is_required');?>" data-msg-remote="<?php __('lblPickupWorkingTime');?>">
                                            <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="input-group">
                                            <input type="text" name="modify_prices[0][date_to]" value="" class="form-control datepick required" data-wt="open" readonly="readonly" data-msg-required="<?php __('plugin_base_this_field_is_required');?>" data-msg-remote="<?php __('lblPickupWorkingTime');?>">
                                            <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                                        </div>
                                    </td>
                                    <td>
                                        <select name="modify_prices[0][location_id]" class="form-control">
                                            <option value="0">-- <?php echo __('lblModifyPricesAllLocations'); ?> --</option>
                                            <?php if (!empty($tpl['locations'])): ?>
                                                <?php foreach ($tpl['locations'] as $location): ?>
                                                    <option value="<?php echo $location['id']; ?>"><?php echo $location['name']; ?></option>
                                                <?php endforeach; ?>
                                            <?php endif; ?>
                                        </select>
                                    </td>
                                    <td>
                                        <select name="modify_prices[0][type_id][]" class="form-control multiple" multiple required>
                                            <option value="0">-- <?php echo __('lblModifyPricesAllTypes'); ?> --</option>
                                            <?php if (!empty($tpl['types'])): ?>
                                                <?php foreach ($tpl['types'] as $type): ?>
                                                    <option value="<?php echo $type['id']; ?>"><?php echo $type['name']; ?></option>
                                                <?php endforeach; ?>
                                            <?php endif; ?>
                                        </select>
                                    </td>
                                    <td>
                                        <input type="text" class="form-control" name="modify_prices[0][percent]">
                                    </td>
                                    <td>
                                        <select name="modify_prices[0][type]" class="form-control" required>
                                            <option value=""></option>
                                            <option value="increase"><?php __('lblModifyPricesIncrease'); ?></option>
                                            <option value="decrease"><?php __('lblModifyPricesDecrease'); ?></option>
                                        </select>
                                    </td>
                                    <td class="text-center">
                                        <a href="javascript:;" class="btn btn-danger btn-outline btn-sm m-l-xs btnRemoveModifyPrice"><i class="fa fa-trash"></i></a>
                                    </td>
                                </tr>
                            <?php endif; ?>
                            </tbody>
                        </table>
                    </div>

                    <button type="button" id="btnAddModifyPrice" class="btn btn-default"><?php __('btnModifyPricesAdd'); ?></button>

                    <div class="hr-line-dashed"></div>

                    <div class="clearfix">
                        <button class="ladda-button btn btn-primary btn-lg pull-left btn-phpjabbers-loader" data-style="zoom-in">
                            <span class="ladda-label"><?php __('plugin_base_btn_save'); ?></span>
                            <?php include $controller->getConstant('pjBase', 'PLUGIN_VIEWS_PATH') . 'pjLayouts/elements/button-animation.php'; ?>
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div><!-- /.col-lg-12 -->
</div>

<table style="display: none;" id="tblModifyPricesClone">
    <thead>
    <tbody>
    <tr>
        <td>
            <div class="input-group">
                <input type="text" name="modify_prices[{INDEX}][date_from]" value="" class="form-control {DATEPICK} required" data-wt="open" readonly="readonly" data-msg-required="<?php __('plugin_base_this_field_is_required');?>" data-msg-remote="<?php __('lblPickupWorkingTime');?>">
                <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
            </div>
        </td>
        <td>
            <div class="input-group">
                <input type="text" name="modify_prices[{INDEX}][date_to]" value="" class="form-control {DATEPICK} required" data-wt="open" readonly="readonly" data-msg-required="<?php __('plugin_base_this_field_is_required');?>" data-msg-remote="<?php __('lblPickupWorkingTime');?>">
                <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
            </div>
        </td>
        <td>
            <select name="modify_prices[{INDEX}][location_id]" class="form-control">
                <option value="0">-- <?php echo __('lblModifyPricesAllLocations'); ?> --</option>
                <?php if (!empty($tpl['locations'])): ?>
                    <?php foreach ($tpl['locations'] as $location): ?>
                        <option value="<?php echo $location['id']; ?>"><?php echo $location['name']; ?></option>
                    <?php endforeach; ?>
                <?php endif; ?>
            </select>
        </td>
        <td>
            <select name="modify_prices[{INDEX}][type_id][]" class="form-control {MULTIPLE}" multiple required>
                <option value="0">-- <?php echo __('lblModifyPricesAllTypes'); ?> --</option>
                <?php if (!empty($tpl['types'])): ?>
                    <?php foreach ($tpl['types'] as $type): ?>
                        <option value="<?php echo $type['id']; ?>"><?php echo $type['name']; ?></option>
                    <?php endforeach; ?>
                <?php endif; ?>
            </select>
        </td>
        <td>
            <input type="text" class="form-control" name="modify_prices[{INDEX}][percent]">
        </td>
        <td>
            <select name="modify_prices[{INDEX}][type]" class="form-control" required>
                <option value=""></option>
                <option value="increase"><?php __('lblModifyPricesIncrease'); ?></option>
                <option value="decrease"><?php __('lblModifyPricesDecrease'); ?></option>
            </select>
        </td>
        <td class="text-center">
            <a href="javascript:;" class="btn btn-danger btn-outline btn-sm m-l-xs btnRemoveModifyPrice"><i class="fa fa-trash"></i></a>
        </td>
    </tr>
    </tbody>
</table>

<script>
    var myLabel = myLabel || {};
    myLabel.choose = <?php x__encode('lblChoose', false, true); ?>;
</script>