<?php
    $titles = __('error_titles', true);
    $bodies = __('error_bodies', true);
?>
<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-sm-12">
        <div class="row">
            <div class="col-lg-12 col-md-12 col-sm-12">
                <h2><?php echo __('infoLocationsFeesTitle', true); ?></h2>
            </div>
        </div>
    </div>
</div>

<div class="row wrapper wrapper-content animated fadeInRight">
    <?php
        $error_code = $controller->_get->toString('err');
        if (!empty($error_code))
        {
            switch (true)
            {
                case in_array($error_code, array('ALF01')):
                    ?>
                    <div class="alert alert-success">
                        <i class="fa fa-check m-r-xs"></i>
                        <strong><?php echo @$titles[$error_code]; ?></strong>
                        <?php echo @$bodies[$error_code]?>
                    </div>
                    <?php
                    break;
                case in_array($error_code, array('')):
                    ?>
                    <div class="alert alert-danger">
                        <i class="fa fa-exclamation-triangle m-r-xs"></i>
                        <strong><?php echo @$titles[$error_code]; ?></strong>
                        <?php echo @$bodies[$error_code]?>
                    </div>
                    <?php
                    break;
            }
        }
    ?>
    <div class="col-lg-12">
        <div class="ibox float-e-margins">
            <div class="ibox-content">
                <form action="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminOptions&amp;action=pjActionLocationsFees" method="post" class="form-horizontal" id="frmUpdateOptions">
                    <input type="hidden" name="locations_fees" value="1" />

                    <div class="table-responsive table-responsive-secondary">
                        <table class="table table-striped table-hover" id="tblLocationFees">
                            <thead>
                                <tr>
                                    <th><?php __('lblLocationFeePickup'); ?></th>
                                    <th><?php __('lblLocationFeeDropoff'); ?></th>
                                    <th><?php __('lblLocationFeeFee'); ?></th>
                                    <th></th>
                                </tr>
                            </thead>
                            <tbody>
                            <?php if (!empty($tpl['locationsFees'])): ?>
                                <?php foreach ($tpl['locationsFees'] as $locationsFee): ?>
                                    <tr>
                                        <td>
                                            <select name="locations[<?php echo $locationsFee['id']; ?>][pickup_id]" class="form-control">
                                                <option value="0">-- <?php echo __('lblAllLocationsFees'); ?> --</option>
                                                <?php if (!empty($tpl['locations'])): ?>
                                                    <?php foreach ($tpl['locations'] as $location): ?>
                                                        <option value="<?php echo $location['id']; ?>" <?php echo ($location['id'] == $locationsFee['pickup_id']) ? 'selected' : ''; ?>><?php echo $location['name']; ?></option>
                                                    <?php endforeach; ?>
                                                <?php endif; ?>
                                            </select>
                                        </td>
                                        <td>
                                            <select name="locations[<?php echo $locationsFee['id']; ?>][dropoff_id]" class="form-control">
                                                <option value="0">-- <?php echo __('lblAllLocationsFees'); ?> --</option>
                                                <?php if (!empty($tpl['locations'])): ?>
                                                    <?php foreach ($tpl['locations'] as $location): ?>
                                                        <option value="<?php echo $location['id']; ?>" <?php echo ($location['id'] == $locationsFee['dropoff_id']) ? 'selected' : ''; ?>><?php echo $location['name']; ?></option>
                                                    <?php endforeach; ?>
                                                <?php endif; ?>
                                            </select>
                                        </td>
                                        <td>
                                            <input type="text" class="form-control" name="locations[<?php echo $locationsFee['id']; ?>][fee]" value="<?php echo $locationsFee['fee']; ?>">
                                        </td>
                                        <td class="text-center">
                                            <a href="javascript:;" class="btn btn-danger btn-outline btn-sm m-l-xs btnRemoveLocationFee"><i class="fa fa-trash"></i></a>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            <?php else: ?>
                                <tr>
                                    <td>
                                        <select name="locations[0][pickup_id]" class="form-control">
                                            <option value="0">-- <?php echo __('lblAllLocationsFees'); ?> --</option>
                                            <?php if (!empty($tpl['locations'])): ?>
                                                <?php foreach ($tpl['locations'] as $location): ?>
                                                    <option value="<?php echo $location['id']; ?>"><?php echo $location['name']; ?></option>
                                                <?php endforeach; ?>
                                            <?php endif; ?>
                                        </select>
                                    </td>
                                    <td>
                                        <select name="locations[0][dropoff_id]" class="form-control">
                                            <option value="0">-- <?php echo __('lblAllLocationsFees'); ?> --</option>
                                            <?php if (!empty($tpl['locations'])): ?>
                                                <?php foreach ($tpl['locations'] as $location): ?>
                                                    <option value="<?php echo $location['id']; ?>"><?php echo $location['name']; ?></option>
                                                <?php endforeach; ?>
                                            <?php endif; ?>
                                        </select>
                                    </td>
                                    <td>
                                        <input type="text" class="form-control" name="locations[0][fee]">
                                    </td>
                                    <td class="text-center">
                                        <a href="javascript:;" class="btn btn-danger btn-outline btn-sm m-l-xs btnRemoveLocationFee"><i class="fa fa-trash"></i></a>
                                    </td>
                                </tr>
                            <?php endif; ?>
                            </tbody>
                        </table>
                    </div>

                    <button type="button" id="btnAddLocationFee" class="btn btn-default"><?php __('btnLocationFeeAdd'); ?></button>

                    <div class="hr-line-dashed"></div>

                    <div class="clearfix">
                        <button class="ladda-button btn btn-primary btn-lg pull-left btn-phpjabbers-loader" data-style="zoom-in">
                            <span class="ladda-label"><?php __('plugin_base_btn_save'); ?></span>
                            <?php include $controller->getConstant('pjBase', 'PLUGIN_VIEWS_PATH') . 'pjLayouts/elements/button-animation.php'; ?>
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div><!-- /.col-lg-12 -->
</div>

<table style="display: none;" id="tblLocationFeeClone">
    <thead>
    <tbody>
        <tr>
            <td>
                <select name="locations[{INDEX}][pickup_id]" class="form-control" required>
                    <option value="0">-- <?php echo __('lblAllLocationsFees'); ?> --</option>
                    <?php if (!empty($tpl['locations'])): ?>
                        <?php foreach ($tpl['locations'] as $location): ?>
                            <option value="<?php echo $location['id']; ?>"><?php echo $location['name']; ?></option>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </select>
            </td>
            <td>
                <select name="locations[{INDEX}][dropoff_id]" class="form-control" required>
                    <option value="0">-- <?php echo __('lblAllLocationsFees'); ?> --</option>
                    <?php if (!empty($tpl['locations'])): ?>
                        <?php foreach ($tpl['locations'] as $location): ?>
                            <option value="<?php echo $location['id']; ?>"><?php echo $location['name']; ?></option>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </select>
            </td>
            <td>
                <input type="text" class="form-control" name="locations[{INDEX}][fee]" required>
            </td>
            <td class="text-center">
                <a href="javascript:;" class="btn btn-danger btn-outline btn-sm m-l-xs btnRemoveLocationFee"><i class="fa fa-trash"></i></a>
            </td>
        </tr>
    </tbody>
</table>