<?php
    if (!defined("ROOT_PATH")) {
        header("HTTP/1.1 403 Forbidden");
        exit;
    }

    class pjLocationFeeModel extends pjAppModel
    {
        /**
         * The name of table's primary key. If PK is over 2 or more columns set this to boolean null
         *
         * @var string
         * @access public
         */
        var $primaryKey = 'id';

        /**
         * The name of table associate with current model
         *
         * @var string
         * @access protected
         */
        var $table = 'locations_fees';

        /**
         * Table schema
         *
         * @var array
         * @access protected
         */
        protected $schema = array(
            array('name' => 'id', 'type' => 'int', 'default' => ':NULL'),
            array('name' => 'pickup_id', 'type' => 'int', 'default' => ':NULL'),
            array('name' => 'dropoff_id', 'type' => 'int', 'default' => ':NULL'),
            array('name' => 'dropoff_type', 'type' => 'varchar', 'default' => ':NULL'),
            array('name' => 'fee', 'type' => 'decimal', 'default' => ':NULL')
        );

        protected $validate = array();

        public $i18n = array();

        public static function factory($attr = array())
        {
            return new self($attr);
        }
    
        /**
         * @param int $pickupId
         * @param int $dropoffId
         *
         * @return int
         */ 

     

        public function getFeeAmount($pickupId, $dropoffId, $vehicletype = 'all')
        {
            // echo "<pre>"; print_r($dropoffId); echo "</pre>"; echo "<pre>"; print_r($vehicletype); echo "</pre>"; die('okk');
            $locationFee = $this->reset()
                ->where('(pickup_id = ' . $pickupId . ' OR pickup_id = 0)')
                ->where('(dropoff_id = ' . $dropoffId . ' OR dropoff_id = 0)')
                // ->where('(dropoff_type = "' . $vehicletype . '" OR dropoff_type = "all")')
                ->where('(dropoff_type = "' . $vehicletype . '" OR dropoff_type = "all" OR dropoff_type IS NULL)')
                ->findAll()
                ->getDataIndex(0);

            if (!$locationFee) {
                return 0;
            }

            return $locationFee['fee'];
        }
    }

?>