START TRANSACTION;

  INSERT INTO `plugin_base_fields` VALUES (NULL, 'menuLocationsFees', 'backend', 'Menu / Locations Fees', 'script', NULL);
  SET @id := (SELECT LAST_INSERT_ID());
  INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Locations Fees', 'script');

  SET @level_1_id := (SELECT `id` FROM `plugin_auth_permissions` WHERE `key`='pjAdminOptions');

  INSERT INTO `plugin_auth_permissions` (`id`, `parent_id`, `key`) VALUES (NULL, @level_1_id, 'pjAdminOptions_pjActionLocationsFees');
  SET @level_2_id := (SELECT LAST_INSERT_ID());
  INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @level_2_id, 'pjAuthPermission', '::LOCALE::', 'title', 'Locations Fees', 'data');

  INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjAdminOptions_pjActionLocationsFees', 'backend', 'pjAdminOptions_pjActionLocationsFees', 'script', '2015-03-20 11:37:44');
  SET @id := (SELECT LAST_INSERT_ID());
  INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Locations Fees', 'script');

  INSERT INTO `plugin_base_fields` VALUES (NULL, 'infoLocationsFeesTitle', 'backend', 'Info / Locations Fees Title', 'script', NULL);
  SET @id := (SELECT LAST_INSERT_ID());
  INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Locations Fees', 'script');

  INSERT INTO `plugin_base_fields` VALUES (NULL, 'lblAllLocationsFees', 'backend', 'Label / All locations', 'script', NULL);
  SET @id := (SELECT LAST_INSERT_ID());
  INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'All locations', 'script');

  INSERT INTO `plugin_base_fields` VALUES (NULL, 'lblLocationFeePickup', 'backend', 'Label / Location fee pickup', 'script', NULL);
  SET @id := (SELECT LAST_INSERT_ID());
  INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Pickup Location', 'script');

  INSERT INTO `plugin_base_fields` VALUES (NULL, 'lblLocationFeeDropoff', 'backend', 'Label / Location fee drop-off', 'script', NULL);
  SET @id := (SELECT LAST_INSERT_ID());
  INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Drop-off Location', 'script');

  INSERT INTO `plugin_base_fields` VALUES (NULL, 'lblLocationFeeFee', 'backend', 'Label / Location fee fee', 'script', NULL);
  SET @id := (SELECT LAST_INSERT_ID());
  INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Fee', 'script');

  INSERT INTO `plugin_base_fields` VALUES (NULL, 'btnLocationFeeAdd', 'backend', 'Label / Location fee add', 'script', NULL);
  SET @id := (SELECT LAST_INSERT_ID());
  INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', '+ Add', 'script');

  INSERT INTO `plugin_base_fields` VALUES (NULL, 'error_titles_ARRAY_ALF01', 'arrays', 'error_titles_ARRAY_ALF01', 'script', NULL);
  SET @id := (SELECT LAST_INSERT_ID());
  INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Locations fees has been saved', 'script');

  DROP TABLE IF EXISTS `locations_fees`;
  CREATE TABLE `locations_fees` (
    `id` INT UNSIGNED NOT NULL AUTO_INCREMENT ,
    `pickup_id` INT UNSIGNED NULL ,
    `dropoff_id` INT UNSIGNED NULL ,
    `fee` DECIMAL(9,2) UNSIGNED NULL ,
    PRIMARY KEY (`id`),
    UNIQUE (`pickup_id`, `dropoff_id`)
  ) ENGINE = InnoDB;

  INSERT INTO `plugin_base_fields` VALUES (NULL, 'front_3_location_fee', 'frontend', 'Label / Location fee', 'script', NULL);
  SET @id := (SELECT LAST_INSERT_ID());
  INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Location fee', 'script');

  ALTER TABLE `bookings` ADD `location_fee` DECIMAL(9,2) NULL AFTER `extra_price`;

  INSERT INTO `plugin_base_fields` VALUES (NULL, 'booking_location_fee', 'backend', 'Label / Location fee', 'script', NULL);
  SET @id := (SELECT LAST_INSERT_ID());
  INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Location fee', 'script');

  SET @id := (SELECT `id` FROM `fields` WHERE `key`='opt_o_email_body_text');
  UPDATE `multi_lang` SET `content`='<div class="col-xs-6">
<div><small>{Title}</small></div>
<div><small>{Name}</small></div>
<div><small>{Email}</small></div>
<div><small>{Phone}</small></div>
<div><small>{Country}</small></div>
<div><small>{City}</small></div>
<div><small>{State}</small></div>
<div><small>{Zip}</small></div>
<div><small>{Address}</small></div>
<div><small>{Company}</small></div>
<div><small>{Notes}</small></div>
<div><small>{DtFrom}{DtTo}</small></div>
</div>
<div class="col-xs-6">
<div><small>{PickupLocation}</small></div>
<div><small>{ReturnLocation}</small></div>
<div><small>{Type}</small></div>
<div><small>{Extras}</small></div>
<div><small>{BookingID}</small></div>
<div><small>{UniqueID}</small></div>
<div><small>{Deposit}</small></div>
<div><small>{Total}</small></div>
<div><small>{Tax}</small></div>
<div><small>{LocationFee}</small></div>
<div><small>{Security}</small></div>
<div><small>{Insurance}</small></div>
<div><small>{PaymentMethod}</small></div>
<div><small>{CancelURL}</small></div>
<div><small>{VoucherCode}</small></div>
<div><small>{VoucherDiscount}</small></div>
 </div>
' WHERE `foreign_id`=@id AND `model`='pjField' AND `field`='title';

  DROP TABLE IF EXISTS `requests`;
  CREATE TABLE `requests` (
    `id` INT UNSIGNED NOT NULL AUTO_INCREMENT ,
    `date_from` DATE NULL ,
    `date_to` DATE NULL ,
    `location_id` INT UNSIGNED NULL ,
    `type_id` INT UNSIGNED NULL ,
    PRIMARY KEY (`id`)
  ) ENGINE = InnoDB;

  INSERT INTO `plugin_base_fields` VALUES (NULL, 'menuRequests', 'backend', 'Menu / Requests', 'script', NULL);
  SET @id := (SELECT LAST_INSERT_ID());
  INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Requests', 'script');

  SET @level_1_id := (SELECT `id` FROM `plugin_auth_permissions` WHERE `key`='pjAdminOptions');

  INSERT INTO `plugin_auth_permissions` (`id`, `parent_id`, `key`) VALUES (NULL, @level_1_id, 'pjAdminOptions_pjActionRequests');
  SET @level_2_id := (SELECT LAST_INSERT_ID());
  INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @level_2_id, 'pjAuthPermission', '::LOCALE::', 'title', 'Requests', 'data');

  INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjAdminOptions_pjActionRequests', 'backend', 'pjAdminOptions_pjActionRequests', 'script', '2015-03-20 11:37:44');
  SET @id := (SELECT LAST_INSERT_ID());
  INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Requests', 'script');

  INSERT INTO `plugin_base_fields` VALUES (NULL, 'infoRequestsTitle', 'backend', 'Info / Requests Title', 'script', NULL);
  SET @id := (SELECT LAST_INSERT_ID());
  INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Requests', 'script');

  INSERT INTO `plugin_base_fields` VALUES (NULL, 'error_titles_ARRAY_AOR01', 'arrays', 'error_titles_ARRAY_AOR01', 'script', NULL);
  SET @id := (SELECT LAST_INSERT_ID());
  INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Requests has been saved', 'script');

  INSERT INTO `plugin_base_fields` VALUES (NULL, 'btnRequestAdd', 'backend', 'Label / Request add', 'script', NULL);
  SET @id := (SELECT LAST_INSERT_ID());
  INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', '+ Add', 'script');

  INSERT INTO `plugin_base_fields` VALUES (NULL, 'lblRequestsAllLocations', 'backend', 'Label / Request all locations', 'script', NULL);
  SET @id := (SELECT LAST_INSERT_ID());
  INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'All locations', 'script');

  INSERT INTO `plugin_base_fields` VALUES (NULL, 'lblRequestsAllTypes', 'backend', 'Label / Request all types', 'script', NULL);
  SET @id := (SELECT LAST_INSERT_ID());
  INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'All types', 'script');

  INSERT INTO `plugin_base_fields` VALUES (NULL, 'lblOnRequest', 'backend', 'Label / On request', 'script', NULL);
  SET @id := (SELECT LAST_INSERT_ID());
  INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'On request', 'script');

  INSERT INTO `notifications` (`id`, `recipient`, `transport`, `variant`, `is_active`) VALUES
    (NULL, 'client', 'email', 'request', '1'),
    (NULL, 'admin', 'email', 'request', '1');

  INSERT INTO `plugin_base_fields` VALUES (NULL, 'notifications_titles_ARRAY_client_email_request', 'arrays', 'Notifications / Client email request (title)', 'script', '2018-05-31 06:59:17');
  SET @id := (SELECT LAST_INSERT_ID());
  INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Send request email to client', 'script');

  INSERT INTO `plugin_base_fields` VALUES (NULL, 'notifications_subtitles_ARRAY_client_email_request', 'arrays', 'Notifications / Client email request (sub-title)', 'script', '2018-05-31 07:02:47');
  SET @id := (SELECT LAST_INSERT_ID());
  INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'This message is sent to client when a request is made.', 'script');

  INSERT INTO `plugin_base_fields` VALUES (NULL, 'notifications_titles_ARRAY_admin_email_request', 'arrays', 'Notifications / Admin email request (title)', 'script', '2018-05-31 06:59:17');
  SET @id := (SELECT LAST_INSERT_ID());
  INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Send request email to admin', 'script');

  INSERT INTO `plugin_base_fields` VALUES (NULL, 'notifications_subtitles_ARRAY_admin_email_request', 'arrays', 'Notifications / Admin email request (sub-title)', 'script', '2018-05-31 07:02:47');
  SET @id := (SELECT LAST_INSERT_ID());
  INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'This message is sent to admin when a request is made.', 'script');

  INSERT INTO `plugin_base_fields` VALUES (NULL, 'notifications_ARRAY_client_email_request', 'arrays', 'Notifications / Send request email', 'script', '2018-05-31 07:02:47');
  SET @id := (SELECT LAST_INSERT_ID());
  INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Send request email', 'script');

  INSERT INTO `plugin_base_fields` VALUES (NULL, 'notifications_ARRAY_admin_email_request', 'arrays', 'Notifications / Send request email', 'script', '2018-05-31 07:02:47');
  SET @id := (SELECT LAST_INSERT_ID());
  INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Send request email', 'script');

  DROP TABLE IF EXISTS `modify_prices`;
  CREATE TABLE `modify_prices` (
    `id` INT UNSIGNED NOT NULL AUTO_INCREMENT ,
    `date_from` DATE NULL ,
    `date_to` DATE NULL ,
    `location_id` INT NULL ,
    `type_id` INT NULL ,
    `percent` INT NULL ,
    `type` ENUM('increase','decrease') NULL ,
    PRIMARY KEY (`id`)
  ) ENGINE = InnoDB;

  INSERT INTO `plugin_base_fields` VALUES (NULL, 'menuModifyPrices', 'backend', 'Menu / Modify Prices', 'script', NULL);
  SET @id := (SELECT LAST_INSERT_ID());
  INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Modify Prices', 'script');

  SET @level_1_id := (SELECT `id` FROM `plugin_auth_permissions` WHERE `key`='pjAdminOptions');

  INSERT INTO `plugin_auth_permissions` (`id`, `parent_id`, `key`) VALUES (NULL, @level_1_id, 'pjAdminOptions_pjActionModifyPrices');
  SET @level_2_id := (SELECT LAST_INSERT_ID());
  INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @level_2_id, 'pjAuthPermission', '::LOCALE::', 'title', 'ModifyPrices', 'data');

  INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjAdminOptions_pjActionModifyPrices', 'backend', 'pjAdminOptions_pjActionModifyPrices', 'script', '2015-03-20 11:37:44');
  SET @id := (SELECT LAST_INSERT_ID());
  INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Modify Prices', 'script');

  INSERT INTO `plugin_base_fields` VALUES (NULL, 'infoModifyPricesTitle', 'backend', 'Info / Modify Prices Title', 'script', NULL);
  SET @id := (SELECT LAST_INSERT_ID());
  INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Modify Prices', 'script');

  INSERT INTO `plugin_base_fields` VALUES (NULL, 'error_titles_ARRAY_AOMP01', 'arrays', 'error_titles_ARRAY_AOMP01', 'script', NULL);
  SET @id := (SELECT LAST_INSERT_ID());
  INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Modify Prices has been saved', 'script');

  INSERT INTO `plugin_base_fields` VALUES (NULL, 'btnModifyPricesAdd', 'backend', 'Label / Modify Prices add', 'script', NULL);
  SET @id := (SELECT LAST_INSERT_ID());
  INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', '+ Add', 'script');

  INSERT INTO `plugin_base_fields` VALUES (NULL, 'lblModifyPricesAllLocations', 'backend', 'Label / Modify Prices all locations', 'script', NULL);
  SET @id := (SELECT LAST_INSERT_ID());
  INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'All locations', 'script');

  INSERT INTO `plugin_base_fields` VALUES (NULL, 'lblModifyPricesAllTypes', 'backend', 'Label / Modify Prices all types', 'script', NULL);
  SET @id := (SELECT LAST_INSERT_ID());
  INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'All types', 'script');

  INSERT INTO `plugin_base_fields` VALUES (NULL, 'lblModifyPricesDateFrom', 'backend', 'Label / Modify Prices Date from', 'script', NULL);
  SET @id := (SELECT LAST_INSERT_ID());
  INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Date from', 'script');

  INSERT INTO `plugin_base_fields` VALUES (NULL, 'lblModifyPricesDateTo', 'backend', 'Label / Modify Prices Date to', 'script', NULL);
  SET @id := (SELECT LAST_INSERT_ID());
  INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Date to', 'script');

  INSERT INTO `plugin_base_fields` VALUES (NULL, 'lblModifyPricesLocation', 'backend', 'Label / Modify Prices Location', 'script', NULL);
  SET @id := (SELECT LAST_INSERT_ID());
  INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Location', 'script');

  INSERT INTO `plugin_base_fields` VALUES (NULL, 'lblModifyPricesType', 'backend', 'Label / Modify Prices Type', 'script', NULL);
  SET @id := (SELECT LAST_INSERT_ID());
  INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Type', 'script');

  INSERT INTO `plugin_base_fields` VALUES (NULL, 'lblModifyPricesPercent', 'backend', 'Label / Modify Prices Percent', 'script', NULL);
  SET @id := (SELECT LAST_INSERT_ID());
  INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Percent', 'script');

  INSERT INTO `plugin_base_fields` VALUES (NULL, 'lblModifyPricesIncreaseDecrease', 'backend', 'Label / Modify Prices Increase/Decrease', 'script', NULL);
  SET @id := (SELECT LAST_INSERT_ID());
  INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Increase / Decrease', 'script');

  INSERT INTO `plugin_base_fields` VALUES (NULL, 'lblModifyPricesIncrease', 'backend', 'Label / Modify Prices Increase', 'script', NULL);
  SET @id := (SELECT LAST_INSERT_ID());
  INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Increase', 'script');

  INSERT INTO `plugin_base_fields` VALUES (NULL, 'lblModifyPricesDecrease', 'backend', 'Label / Modify Prices Decrease', 'script', NULL);
  SET @id := (SELECT LAST_INSERT_ID());
  INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Decrease', 'script');

  INSERT INTO `plugin_base_fields` VALUES (NULL, 'lblRequestsDateFrom', 'backend', 'Label / Requests Date from', 'script', NULL);
  SET @id := (SELECT LAST_INSERT_ID());
  INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Date from', 'script');

  INSERT INTO `plugin_base_fields` VALUES (NULL, 'lblRequestsDateTo', 'backend', 'Label / Requests Date to', 'script', NULL);
  SET @id := (SELECT LAST_INSERT_ID());
  INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Date to', 'script');

  INSERT INTO `plugin_base_fields` VALUES (NULL, 'lblRequestsLocation', 'backend', 'Label / Requests Location', 'script', NULL);
  SET @id := (SELECT LAST_INSERT_ID());
  INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Location', 'script');

  INSERT INTO `plugin_base_fields` VALUES (NULL, 'lblRequestsType', 'backend', 'Label / Requests Type', 'script', NULL);
  SET @id := (SELECT LAST_INSERT_ID());
  INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Type', 'script');

  DROP TABLE IF EXISTS `modify_prices_types`;
  CREATE TABLE `modify_prices_types` (
    `id` INT UNSIGNED NOT NULL AUTO_INCREMENT ,
    `modify_price_id` INT UNSIGNED NOT NULL ,
    `type_id` INT UNSIGNED NULL ,
    PRIMARY KEY (`id`),
    INDEX (`modify_price_id`)
  ) ENGINE = InnoDB;

  ALTER TABLE `modify_prices` DROP `type_id`;

  INSERT INTO `options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES
    (1, 'o_night_fee_1', 1, '56.00', NULL, 'float', 1, 1, NULL),
    (1, 'o_night_fee_2', 1, '82.00', NULL, 'float', 2, 1, NULL);

  INSERT INTO `fields` VALUES (NULL, 'opt_o_night_fee_1', 'backend', 'Options / Night fee 1', 'script', NULL);
  SET @id := (SELECT LAST_INSERT_ID());
  INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Night fee 1', 'script');

  INSERT INTO `fields` VALUES (NULL, 'opt_o_night_fee_1_text', 'backend', 'Options / Night fee 1 description', 'script', NULL);
  SET @id := (SELECT LAST_INSERT_ID());
  INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Apply if client wants to rent the car between 22:00 -> 23:30 and 07:00 -> 08:00', 'script');

  INSERT INTO `fields` VALUES (NULL, 'opt_o_night_fee_2', 'backend', 'Options / Night fee 1', 'script', NULL);
  SET @id := (SELECT LAST_INSERT_ID());
  INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Night fee 2', 'script');

  INSERT INTO `fields` VALUES (NULL, 'opt_o_night_fee_2_text', 'backend', 'Options / Night fee 2 description', 'script', NULL);
  SET @id := (SELECT LAST_INSERT_ID());
  INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Apply if client wants to rent the car between 23:31 -> 06:59', 'script');

  UPDATE `options` SET `order` = 3 WHERE `key` = 'o_unit';
  UPDATE `options` SET `order` = 4 WHERE `key` = 'o_booking_periods';
  UPDATE `options` SET `order` = 5 WHERE `key` = 'o_new_day_per_day';
  UPDATE `options` SET `order` = 6 WHERE `key` = 'o_min_hour';
  UPDATE `options` SET `order` = 7 WHERE `key` = 'o_theme';
  UPDATE `options` SET `order` = 8 WHERE `key` = 'o_booking_pending';
  UPDATE `options` SET `order` = 9 WHERE `key` = 'o_time_period';
  UPDATE `options` SET `order` = 10 WHERE `key` = 'o_deposit_payment';
  UPDATE `options` SET `order` = 11 WHERE `key` = 'o_deposit_type';
  UPDATE `options` SET `order` = 12 WHERE `key` = 'o_tax_payment';
  UPDATE `options` SET `order` = 13 WHERE `key` = 'o_tax_type';
  UPDATE `options` SET `order` = 14 WHERE `key` = 'o_security_payment';
  UPDATE `options` SET `order` = 15 WHERE `key` = 'o_insurance_payment';
  UPDATE `options` SET `order` = 16 WHERE `key` = 'o_insurance_payment_type';
  UPDATE `options` SET `order` = 17 WHERE `key` = 'o_booking_status';
  UPDATE `options` SET `order` = 18 WHERE `key` = 'o_payment_status';
  UPDATE `options` SET `order` = 19 WHERE `key` = 'o_payment_disable';
  UPDATE `options` SET `order` = 20 WHERE `key` = 'o_thankyou_page';
  UPDATE `options` SET `order` = 21 WHERE `key` = 'o_website_seo';
  UPDATE `options` SET `order` = 22 WHERE `key` = 'o_cancel_booking_page';

  ALTER TABLE `bookings` ADD `night_fee` DECIMAL(9,2) NULL AFTER `location_fee`;

  INSERT INTO `fields` VALUES (NULL, 'lblNightFee', 'backend', 'Label / Night fee', 'script', NULL);
  SET @id := (SELECT LAST_INSERT_ID());
  INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Night fee', 'script');

  INSERT INTO `fields` VALUES (NULL, 'booking_night_fee', 'backend', 'Label / Night fee', 'script', NULL);
  SET @id := (SELECT LAST_INSERT_ID());
  INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Night fee', 'script');

  SET @id := (SELECT `id` FROM `fields` WHERE `key`='opt_o_email_body_text');
  UPDATE `multi_lang` SET `content`='<div class="col-xs-6">
<div><small>{Title}</small></div>
<div><small>{Name}</small></div>
<div><small>{Email}</small></div>
<div><small>{Phone}</small></div>
<div><small>{Country}</small></div>
<div><small>{City}</small></div>
<div><small>{State}</small></div>
<div><small>{Zip}</small></div>
<div><small>{Address}</small></div>
<div><small>{Company}</small></div>
<div><small>{Notes}</small></div>
<div><small>{DtFrom}{DtTo}</small></div>
</div>
<div class="col-xs-6">
<div><small>{PickupLocation}</small></div>
<div><small>{ReturnLocation}</small></div>
<div><small>{Type}</small></div>
<div><small>{Extras}</small></div>
<div><small>{BookingID}</small></div>
<div><small>{UniqueID}</small></div>
<div><small>{Deposit}</small></div>
<div><small>{Total}</small></div>
<div><small>{Tax}</small></div>
<div><small>{LocationFee}</small></div>
<div><small>{NightFee}</small></div>
<div><small>{Security}</small></div>
<div><small>{Insurance}</small></div>
<div><small>{PaymentMethod}</small></div>
<div><small>{CancelURL}</small></div>
 </div>
' WHERE `foreign_id`=@id AND `model`='pjField' AND `field`='title';

COMMIT;