
START TRANSACTION;

ALTER TABLE `bookings` ADD COLUMN `extra_mileage_charge` decimal(9,2) unsigned DEFAULT NULL AFTER `required_deposit`;

ALTER TABLE `locations` ADD COLUMN `city` varchar(255) DEFAULT NULL AFTER `zip`;
ALTER TABLE `locations` ADD COLUMN `state` varchar(255) DEFAULT NULL AFTER `city`;
ALTER TABLE `locations` ADD COLUMN `address_1` varchar(255) DEFAULT NULL AFTER `state`;
ALTER TABLE `locations` ADD COLUMN `address_2` varchar(255) DEFAULT NULL AFTER `address_1`;


DELETE FROM `options` WHERE `key` IN ('o_currency', 'o_date_format', 'o_datetime_format', 'o_timezone', 'o_week_start', 'o_send_email', 'o_smtp_host', 'o_smtp_pass', 'o_smtp_port', 'o_smtp_user', 'o_google_map_api');

UPDATE `options` SET `tab_id`=1 WHERE `key` IN ('o_unit','o_booking_periods','o_new_day_per_day','o_min_hour','o_booking_pending','o_deposit_payment','o_deposit_type','o_tax_payment','o_tax_type','o_security_payment','o_insurance_payment','o_insurance_payment_type','o_booking_status','o_payment_status','o_payment_disable','o_thankyou_page','o_cancel_booking_page');
UPDATE `options` SET `is_visible`=0 WHERE `key` IN ('o_website_seo');
UPDATE `options` SET `value`="amount|percent::percent", `label`="Amount|Percent", `type`='enum' WHERE `key`='o_tax_type';
UPDATE `options` SET `value`="percent|perday|perbooking::percent", `label`="Percent|Per day|Per Reservation", `type`='enum', `is_visible`=1 WHERE `key`='o_insurance_payment_type';
UPDATE `options` SET `is_visible`=0 WHERE `key` IN ('o_deposit_type','o_tax_type','o_insurance_payment_type');
UPDATE `options` SET `order`=1 WHERE `key`='o_unit';
UPDATE `options` SET `order`=2 WHERE `key`='o_booking_periods'; 
UPDATE `options` SET `order`=3 WHERE `key`='o_new_day_per_day'; 
UPDATE `options` SET `order`=4 WHERE `key`='o_min_hour'; 
UPDATE `options` SET `order`=5 WHERE `key`='o_booking_pending';
UPDATE `options` SET `order`=6 WHERE `key`='o_time_period';
UPDATE `options` SET `order`=7 WHERE `key`='o_deposit_payment';
UPDATE `options` SET `order`=8 WHERE `key`='o_deposit_type';
UPDATE `options` SET `order`=9 WHERE `key`='o_tax_payment';
UPDATE `options` SET `order`=10 WHERE `key`='o_tax_type';
UPDATE `options` SET `order`=11 WHERE `key`='o_security_payment';
UPDATE `options` SET `order`=12 WHERE `key`='o_insurance_payment';
UPDATE `options` SET `order`=13 WHERE `key`='o_insurance_payment_type';
UPDATE `options` SET `order`=14 WHERE `key`='o_booking_status';
UPDATE `options` SET `order`=15 WHERE `key`='o_payment_status';
UPDATE `options` SET `order`=16 WHERE `key`='o_payment_disable';
UPDATE `options` SET `order`=17 WHERE `key`='o_thankyou_page';
UPDATE `options` SET `order`=18 WHERE `key`='o_cancel_booking_page';

UPDATE `options` SET `type`='float' WHERE `key`='o_security_payment';
UPDATE `options` SET `type`='bool', `value`='0|1::0' WHERE `key`='o_payment_disable';

UPDATE `options` SET `tab_id`=2 WHERE `key` IN ('o_bf_include_title','o_bf_include_name','o_bf_include_email','o_bf_include_phone','o_bf_include_company','o_bf_include_address','o_bf_include_country','o_bf_include_state','o_bf_include_city','o_bf_include_zip','o_bf_include_notes','o_bf_include_captcha');
UPDATE `options` SET `tab_id`=3 WHERE `key` IN ('o_terms');

DROP TABLE IF EXISTS `notifications`;
CREATE TABLE IF NOT EXISTS `notifications` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `recipient` enum('client','admin') DEFAULT NULL,
  `transport` enum('email','sms') DEFAULT NULL,
  `variant` varchar(30) DEFAULT NULL,
  `is_active` tinyint(1) unsigned DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `recipient` (`recipient`,`transport`,`variant`),
  KEY `is_active` (`is_active`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

INSERT IGNORE INTO `notifications` (`id`, `recipient`, `transport`, `variant`, `is_active`) VALUES
(1, 'client', 'email', 'confirmation', 1),
(2, 'client', 'email', 'payment', 1),
(3, 'client', 'email', 'cancel', 1),
(4, 'admin', 'email', 'confirmation', 1),
(5, 'admin', 'email', 'payment', 1),
(6, 'admin', 'email', 'cancel', 1),
(7, 'admin', 'sms', 'confirmation', 1),
(8, 'admin', 'sms', 'payment', 1),
(9, 'client', 'sms', 'reminder', 1);


INSERT INTO `plugin_base_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES
(NULL, 1, 'pjOption', 1, 'confirm_sms_admin', 'New booking has been made. ID: {BookingID}', 'script'),
(NULL, 1, 'pjOption', 1, 'payment_sms_admin', 'Reservation deposit has been paid. ID: {BookingID}', 'script'),
(NULL, 1, 'pjOption', 1, 'confirm_subject_admin', 'New reservation received', 'script'),
(NULL, 1, 'pjOption', 1, 'confirm_tokens_admin', 'New booking has been made.<br/><br/>ID: {BookingID}', 'script'),
(NULL, 1, 'pjOption', 1, 'payment_subject_admin', 'New payment received', 'script'),
(NULL, 1, 'pjOption', 1, 'payment_tokens_admin', 'Reservation deposit has been paid.<br/><br/>ID: {BookingID}', 'script'),
(NULL, 1, 'pjOption', 1, 'cancel_subject_admin', 'Reservation cancelled', 'script'),
(NULL, 1, 'pjOption', 1, 'cancel_tokens_admin', 'Reservation has been cancelled.<br/><br/>ID: {BookingID}', 'script'),
(NULL, 1, 'pjOption', 1, 'confirm_subject_client', 'Reservation confirmation', 'script'),
(NULL, 1, 'pjOption', 1, 'confirm_tokens_client', 'Dear {Name},<br/><br/>we''ve received your reservation.<br/><br/>From: {DtFrom}<br/>To: {DtTo}<br/><br/>Pickup Location: {PickupLocation}<br/>Return Location: {ReturnLocation}<br/><br/>ID: {BookingID}<br/><br/>If you want to cancel your booking use this link {CancelURL}<br/><br/>You can contact us at +123 456 789<br/><br/>Regards,<br/>Car Rental Company', 'script'),
(NULL, 1, 'pjOption', 1, 'payment_subject_client', 'Payment confirmation', 'script'),
(NULL, 1, 'pjOption', 1, 'payment_tokens_client', 'Dear {Name},<br/><br/>we''ve received payment for your reservation.<br/><br/>From: {DtFrom}<br/>To: {DtTo}<br/><br/>Pickup Location: {PickupLocation}<br/>Return Location: {ReturnLocation}<br/><br/>ID: {BookingID}<br/><br/>You can contact us at +123 456 789<br/><br/>Regards,<br/>Car Rental Company', 'script'),
(NULL, 1, 'pjOption', 1, 'cancel_subject_client', 'Cancellation confirmation', 'script'),
(NULL, 1, 'pjOption', 1, 'cancel_tokens_client', 'Dear {Name},<br/><br/>you''ve cancelled a reservation.<br/><br/>From: {DtFrom}<br/>To: {DtTo}<br/><br/>Pickup Location: {PickupLocation}<br/>Return Location: {ReturnLocation}<br/><br/>ID: {BookingID}<br/><br/>If you want to cancel your booking use this link {CancelURL}<br/><br/>You can contact us at +123 456 789<br/><br/>Regards,<br/>Car Rental Company', 'script'),
(NULL, 1, 'pjOption', 1, 'reminder_sms_client', '{CustomerName}, your reservation is confirmed on {DtFrom}', 'script');

ALTER TABLE `working_times` ADD COLUMN (
	`monday_lunch_from` time DEFAULT NULL,               
    `monday_lunch_to` time DEFAULT NULL,
    `tuesday_lunch_from` time DEFAULT NULL,              
 	`tuesday_lunch_to` time DEFAULT NULL,
 	`wednesday_lunch_from` time DEFAULT NULL,            
    `wednesday_lunch_to` time DEFAULT NULL,
    `thursday_lunch_from` time DEFAULT NULL,             
    `thursday_lunch_to` time DEFAULT NULL,
    `friday_lunch_from` time DEFAULT NULL,               
    `friday_lunch_to` time DEFAULT NULL,
    `saturday_lunch_from` time DEFAULT NULL,             
    `saturday_lunch_to` time DEFAULT NULL,
    `sunday_lunch_from` time DEFAULT NULL,               
    `sunday_lunch_to` time DEFAULT NULL
);



ALTER TABLE `dates` CHANGE `date` `from_date` date DEFAULT NULL;
ALTER TABLE `dates` ADD COLUMN `to_date` date DEFAULT NULL AFTER `from_date`;

ALTER TABLE `dates` ADD COLUMN (
	`start_lunch` time DEFAULT NULL,                  
	`end_lunch` time DEFAULT NULL,
	`all_day` enum('T','F') DEFAULT 'F'
);

INSERT INTO `plugin_base_fields` VALUES (NULL, 'script_name', 'backend', 'Label / Script name', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Car Rental', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'menuReminder', 'backend', 'Label / Reminder', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Reminder', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'menuTime', 'backend', 'Label / Working Time', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Working Time', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'script_install_your_website', 'backend', 'Label / Install your website', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Install your website', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'script_preview_your_website', 'backend', 'Label / Preview your website', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Open in new window', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjAdminOptions_pjActionPreview', 'backend', 'Label / Preview Menu', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Preview Menu', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjAdminOptions_pjActionInstall', 'backend', 'Label / Integration Code Menu', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Integration Code Menu', 'script');

UPDATE `options` SET `value` = '1|0::1' WHERE `key` = 'o_allow_cash';
INSERT INTO `plugin_base_multi_lang` VALUES(NULL, '1', 'pjPayment', '1', 'cash', 'Cash', 'data');

INSERT INTO `plugin_auth_permissions` (`id`, `parent_id`, `key`) VALUES (NULL, NULL, 'pjAdmin_pjActionIndex');
SET @level_1_id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @level_1_id, 'pjAuthPermission', '::LOCALE::', 'title', 'Dashboard', 'data');

INSERT INTO `plugin_auth_permissions` (`id`, `parent_id`, `key`, `is_shown`) VALUES (NULL, NULL, 'pjAdmin_pjActionProfile', 'F');
SET @level_1_id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @level_1_id, 'pjAuthPermission', '::LOCALE::', 'title', 'Profile', 'data');


INSERT INTO `plugin_auth_permissions` (`id`, `parent_id`, `key`) VALUES (NULL, NULL, 'pjAdminOptions');
SET @level_1_id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @level_1_id, 'pjAuthPermission', '::LOCALE::', 'title', 'Options Menu', 'data');

  INSERT INTO `plugin_auth_permissions` (`id`, `parent_id`, `key`) VALUES (NULL, @level_1_id, 'pjAdminOptions_pjActionBooking');
  SET @level_2_id := (SELECT LAST_INSERT_ID());
  INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @level_2_id, 'pjAuthPermission', '::LOCALE::', 'title', 'Reservation Options', 'data');

  INSERT INTO `plugin_auth_permissions` (`id`, `parent_id`, `key`) VALUES (NULL, @level_1_id, 'pjAdminOptions_pjActionPayments');
  SET @level_2_id := (SELECT LAST_INSERT_ID());
  INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @level_2_id, 'pjAuthPermission', '::LOCALE::', 'title', 'Payment Options', 'data');

  INSERT INTO `plugin_auth_permissions` (`id`, `parent_id`, `key`) VALUES (NULL, @level_1_id, 'pjAdminOptions_pjActionBookingForm');
  SET @level_2_id := (SELECT LAST_INSERT_ID());
  INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @level_2_id, 'pjAuthPermission', '::LOCALE::', 'title', 'Reservation Form', 'data');

  INSERT INTO `plugin_auth_permissions` (`id`, `parent_id`, `key`) VALUES (NULL, @level_1_id, 'pjAdminOptions_pjActionNotifications');
  SET @level_2_id := (SELECT LAST_INSERT_ID());
  INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @level_2_id, 'pjAuthPermission', '::LOCALE::', 'title', 'Notifications', 'data');

  INSERT INTO `plugin_auth_permissions` (`id`, `parent_id`, `key`) VALUES (NULL, @level_1_id, 'pjAdminOptions_pjActionTerm');
  SET @level_2_id := (SELECT LAST_INSERT_ID());
  INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @level_2_id, 'pjAuthPermission', '::LOCALE::', 'title', 'Terms & Conditions', 'data');
  

INSERT INTO `plugin_auth_permissions` (`id`, `parent_id`, `key`) VALUES (NULL, NULL, 'pjAdminOptions_pjActionPreview');
SET @level_1_id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @level_1_id, 'pjAuthPermission', '::LOCALE::', 'title', 'Preview Menu', 'data');

INSERT INTO `plugin_auth_permissions` (`id`, `parent_id`, `key`) VALUES (NULL, NULL, 'pjAdminOptions_pjActionInstall');
SET @level_1_id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @level_1_id, 'pjAuthPermission', '::LOCALE::', 'title', 'Integration Code Menu', 'data');

ALTER TABLE `bookings` MODIFY `payment_method` varchar(255) DEFAULT NULL;
ALTER TABLE `bookings_payments` MODIFY `payment_method` varchar(255) DEFAULT NULL;

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjAdmin_pjActionIndex', 'backend', 'Label / Dashboard', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Dashboard', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjAdmin_pjActionProfile', 'backend', 'Label / Profile', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Profile', 'script');  

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjAdminOptions', 'backend', 'Label / Options Menu', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Options Menu', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjAdminOptions_pjActionBooking', 'backend', 'Label / Reservation Options', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Reservation Options', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjAdminOptions_pjActionPayments', 'backend', 'Label / Payment Options', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Payment Options', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjAdminOptions_pjActionBookingForm', 'backend', 'Label / Reservation Form', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Reservation Form', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjAdminOptions_pjActionNotifications', 'backend', 'Label / Notifications', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Notifications', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjAdminOptions_pjActionTerm', 'backend', 'Label / Terms & Conditions', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Terms & Conditions', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'enum_o_booking_periods_arr_ARRAY_perday', 'arrays', 'enum_o_booking_periods_arr_ARRAY_perday', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Per day only', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'enum_o_booking_periods_arr_ARRAY_perhour', 'arrays', 'enum_o_booking_periods_arr_ARRAY_perhour', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Per hour only', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'enum_o_booking_periods_arr_ARRAY_both', 'arrays', 'enum_o_booking_periods_arr_ARRAY_both', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Per day and per hour', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'enum_o_time_period_arr_ARRAY_12hours', 'arrays', 'enum_o_time_period_arr_ARRAY_12hours', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', '12 hours', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'enum_o_time_period_arr_ARRAY_24hours', 'arrays', 'enum_o_time_period_arr_ARRAY_24hours', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', '24 hours', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'enum_o_deposit_type_arr_ARRAY_amount', 'arrays', 'enum_o_deposit_type_arr_ARRAY_amount', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Amount', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'enum_o_deposit_type_arr_ARRAY_percent', 'arrays', 'enum_o_deposit_type_arr_ARRAY_percent', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Percent', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'enum_o_tax_type_arr_ARRAY_amount', 'arrays', 'enum_o_tax_type_arr_ARRAY_amount', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Amount', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'enum_o_tax_type_arr_ARRAY_percent', 'arrays', 'enum_o_tax_type_arr_ARRAY_percent', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Percent', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'enum_o_insurance_payment_type_arr_ARRAY_percent', 'arrays', 'enum_o_insurance_payment_type_arr_ARRAY_percent', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Percent', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'enum_o_insurance_payment_type_arr_ARRAY_perday', 'arrays', 'enum_o_insurance_payment_type_arr_ARRAY_perday', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Per day', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'enum_o_insurance_payment_type_arr_ARRAY_perbooking', 'arrays', 'enum_o_insurance_payment_type_arr_ARRAY_perbooking', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Per Reservation', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'enum_o_booking_status_arr_ARRAY_confirmed', 'arrays', 'enum_o_booking_status_arr_ARRAY_confirmed', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Confirmed', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'enum_o_booking_status_arr_ARRAY_pending', 'arrays', 'enum_o_booking_status_arr_ARRAY_pending', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Pending', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'enum_o_booking_status_arr_ARRAY_cancelled', 'arrays', 'enum_o_booking_status_arr_ARRAY_cancelled', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Cancel', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'enum_o_payment_status_arr_ARRAY_confirmed', 'arrays', 'enum_o_payment_status_arr_ARRAY_confirmed', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Confirmed', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'enum_o_payment_status_arr_ARRAY_pending', 'arrays', 'enum_o_payment_status_arr_ARRAY_pending', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Pending', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'enum_o_payment_status_arr_ARRAY_cancelled', 'arrays', 'enum_o_payment_status_arr_ARRAY_cancelled', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Cancel', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'enum_arr_ARRAY_1', 'backend', 'enum_arr_ARRAY_1', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'No', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'enum_arr_ARRAY_2', 'backend', 'enum_arr_ARRAY_2', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Yes', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'enum_arr_ARRAY_3', 'backend', 'enum_arr_ARRAY_3', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Yes (required)', 'script');

UPDATE `plugin_base_options` SET `value`='Yes|No::Yes' WHERE `key`='o_auto_backup';


INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjBaseBackup_pjActionAutoBackup', 'backend', 'Label / backup', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Create automatic back-ups for database and files', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjCron_pjActionIndex', 'backend', 'Label / backup', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Send Email and SMS reminders', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'wt_title_over', 'backend', 'Label / Warning', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Warning', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'wt_body_over', 'backend', 'Label / Overwrite current working time', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Do you want to overwrite current working time?', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'invalid_lunch_selected_time', 'backend', 'Label / Invalid lunch time', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Lunch Break From must precede Lunch Break To', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'error_bodies_ARRAY_AO27', 'arrays', 'error_bodies_ARRAY_AO27', 'script', '2013-11-22 10:10:04');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Set different payment options for your Appointment Scheduler software. Enable or disable the available payment processing companies.', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'error_titles_ARRAY_AO27', 'arrays', 'error_titles_ARRAY_AO27', 'script', '2013-09-18 08:47:26');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Booking payment options', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'error_titles_ARRAY_AO25', 'arrays', 'error_titles_ARRAY_AO25', 'script', '2013-09-18 08:44:26');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Confirmation', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'error_bodies_ARRAY_AO25', 'arrays', 'error_bodies_ARRAY_AO25', 'script', '2013-12-12 19:55:12');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Email notifications will be sent to people who make a booking after the booking form is completed or/and payment is made. If you leave subject field blank no email will be sent.', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'lblNotifications', 'backend', 'Label / Notifications', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Notifications', 'script');


INSERT INTO `plugin_base_fields` VALUES (NULL, 'script_menu_settings', 'backend', 'Menu / Settings', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Settings', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'script_menu_notifications', 'backend', 'Menu / Notifications', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Notifications', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'script_emails', 'backend', 'Label / Emails', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Emails', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'script_sms', 'backend', 'Label / SMS', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'SMS', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'script_notifications', 'backend', 'Label / Notifications', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Notifications', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'script_send_this_notifications', 'backend', 'Label / Send this notification', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Send this notification', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'script_subject', 'backend', 'Label / Subject', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Subject', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'script_message', 'backend', 'Label / Message', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Message', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'script_change_labels', 'backend', 'Label / Change Labels', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Change Labels', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'script_menu_payments', 'backend', 'Menu / Payments', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Payments', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'infoPaymentsTitle', 'backend', 'Infobox / Payment options', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Payment Options', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'infoPaymentsDesc', 'backend', 'Infobox / Payments', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Here you can choose your payment methods and set payment gateway accounts and payment preferences. Note that for cash payments the system will not be able to collect deposit amount online.', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'script_offline_payment_methods', 'backend', 'Label / Offline Payment Methods', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Offline Payment Methods', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'script_request_antoher_payment', 'backend', 'Label / Request Another Payment Gateway', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Request Another Payment Gateway', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'script_online_payment_gateway', 'backend', 'Label / Online payment gateway', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Online payment gateway', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'script_offline_payment', 'backend', 'Label / Offline payment', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Offline payment', 'script');


INSERT INTO `plugin_base_fields` VALUES (NULL, 'notifications_ARRAY_client_email_confirmation', 'arrays', 'Notifications / Client email confirmation', 'script', '2018-05-31 06:19:54');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Send confirmation email', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'notifications_ARRAY_client_email_payment', 'arrays', 'Notifications / Client email payment', 'script', '2018-05-31 06:20:22');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Send payment confirmation email', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'notifications_ARRAY_client_email_cancel', 'arrays', 'Notifications / Client email cancel', 'script', '2018-05-31 06:20:44');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Send cancellation email', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'notifications_ARRAY_admin_email_confirmation', 'arrays', 'Notifications / Admin email confirmation', 'script', '2018-05-31 06:22:40');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Send confirmation email', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'notifications_ARRAY_admin_email_payment', 'arrays', 'Notifications / Admin email payment', 'script', '2018-05-31 06:23:02');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Send payment confirmation email', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'notifications_ARRAY_admin_email_cancel', 'arrays', 'Notifications / Admin email cancel', 'script', '2018-05-31 06:23:21');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Send cancellation email', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'notifications_titles_ARRAY_client_email_confirmation', 'arrays', 'Notifications / Client email confirmation (title)', 'script', '2018-05-31 06:44:09');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Booking Confirmation email sent to Client', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'notifications_titles_ARRAY_client_email_payment', 'arrays', 'Notifications / Client email payment (title)', 'script', '2018-05-31 06:45:06');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Payment Confirmation email sent to Client', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'notifications_titles_ARRAY_client_email_cancel', 'arrays', 'Notifications / Client email cancel (title)', 'script', '2018-05-31 06:45:57');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Booking Cancellation email sent to Client', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'notifications_titles_ARRAY_admin_email_confirmation', 'arrays', 'Notifications / Admin email confirmation (title)', 'script', '2018-05-31 06:59:45');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'New Booking Received email sent to Admin', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'notifications_titles_ARRAY_admin_email_payment', 'arrays', 'Notifications / Admin email payment (title)', 'script', '2018-05-31 06:59:31');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Send Payment Confirmation email sent to Admin', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'notifications_titles_ARRAY_admin_email_cancel', 'arrays', 'Notifications / Admin email cancel (title)', 'script', '2018-05-31 06:59:17');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Send Cancellation email sent to Admin', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'notifications_subtitles_ARRAY_client_email_confirmation', 'arrays', 'Notifications / Client email confirmation (sub-title)', 'script', '2018-05-31 07:02:47');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'This message is sent to client when a new reservation is made.', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'notifications_subtitles_ARRAY_client_email_payment', 'arrays', 'Notifications / Client email payment (sub-title)', 'script', '2018-05-31 07:02:37');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'This message is sent to the client when a payment is made for a new reservation.', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'notifications_subtitles_ARRAY_client_email_cancel', 'arrays', 'Notifications / Client email cancel (sub-title)', 'script', '2018-05-31 07:02:28');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'This message is sent to the client when a client cancels a reservation.', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'notifications_subtitles_ARRAY_admin_email_confirmation', 'arrays', 'Notifications / Admin email confirmation (sub-title)', 'script', '2018-05-31 07:01:42');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'This message is sent to the administrator when a new reservation is made.', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'notifications_subtitles_ARRAY_admin_email_payment', 'arrays', 'Notifications / Admin email payment (sub-title)', 'script', '2018-05-31 07:01:31');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'This message is sent to the administrator when a payment for a new reservation is made.', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'notifications_subtitles_ARRAY_admin_email_cancel', 'arrays', 'Notifications / Admin email cancel (sub-title)', 'script', '2018-05-31 07:01:20');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'This message is sent to the administrator when a client cancels a reservation.', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'notifications_subject', 'backend', 'Subject', 'script', '2018-05-31 09:22:57');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Subject', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'notifications_message', 'backend', 'Message', 'script', '2018-05-31 09:23:13');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Message', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'notifications_is_active', 'backend', 'Send this message', 'script', '2018-05-31 09:23:29');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Send this message', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'notifications_sms_na', 'backend', 'SMS not available', 'script', '2018-05-31 09:24:36');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'SMS notifications are currently not available for your website. See details', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'notifications_sms_na_here', 'backend', 'here', 'script', '2018-05-31 09:24:58');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'here', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'notifications_send', 'backend', 'Notifications / Send', 'script', '2018-05-31 09:25:37');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Send', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'notifications_do_not_send', 'backend', 'Notifications / Do not send', 'script', '2018-05-31 09:26:01');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Do not send', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'notifications_status', 'backend', 'Notifications / Status', 'script', '2018-05-31 09:26:20');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Status', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'notifications_msg_to_client', 'backend', 'Notifications / Messages sent to Clients', 'script', '2018-05-31 09:27:01');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Messages sent to Clients', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'notifications_msg_to_admin', 'backend', 'Notifications / Messages sent to Admin', 'script', '2018-05-31 09:30:48');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Messages sent to Admin', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'notifications_msg_to_default', 'backend', 'Notifications / Messages sent to Default', 'script', '2018-05-31 09:31:04');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Messages sent', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'notifications_main_title', 'backend', 'Notifications', 'script', '2018-05-31 09:32:44');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Notifications', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'notifications_main_subtitle', 'backend', 'Notifications (sub-title)', 'script', '2018-05-31 09:33:14');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Automated messages are sent both to client and administrator(s) on specific events. Select message type to edit it - enable/disable or just change message text. For SMS notifications you need to enable SMS service. See more <a href="https://www.phpjabbers.com/web-sms/" target="_blank">here</a>.', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'notifications_recipient', 'backend', 'Notifications / Recipient', 'script', '2018-05-31 09:33:56');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Recipient', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'notifications_tokens_note', 'backend', 'Notifications / Tokens (note)', 'script', '2018-05-31 09:35:19');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Personalize the message by including any of the available tokens and it will be replaced with corresponding data.', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'notifications_tokens', 'backend', 'Notifications / Tokens', 'script', '2018-05-31 09:38:00');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Available tokens:', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'recipients_ARRAY_client', 'arrays', 'Recipients / Client', 'script', '2018-05-31 09:39:03');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Client', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'recipients_ARRAY_admin', 'arrays', 'Recipients / Administrator', 'script', '2018-05-31 09:39:23');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Administrator', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'recipient_admin_note', 'backend', 'Recipients / Administrator (note)', 'script', '2018-05-31 09:40:31');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Go to <a href="index.php?controller=pjBaseUsers&action=pjActionIndex">Users menu</a> and edit each administrator profile to select if they should receive "Admin notifications" or not.', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'opt_o_email_body_text', 'backend', 'Options / Email body text', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES
(NULL, @id, 'pjField', 1, 'title', '<div class="col-xs-6">
<div><small>{Title}</small></div>
<div><small>{Name}</small></div>
<div><small>{Email}</small></div>
<div><small>{Phone}</small></div>
<div><small>{Country}</small></div>
<div><small>{City}</small></div>
<div><small>{State}</small></div>
<div><small>{Zip}</small></div>
<div><small>{Address}</small></div>
<div><small>{Company}</small></div>
<div><small>{Notes}</small></div>
<div><small>{DtFrom}{DtTo}</small></div>
</div>
<div class="col-xs-6">
<div><small>{PickupLocation}</small></div>
<div><small>{ReturnLocation}</small></div>
<div><small>{Type}</small></div>
<div><small>{Extras}</small></div>
<div><small>{BookingID}</small></div>
<div><small>{UniqueID}</small></div>
<div><small>{Deposit}</small></div>
<div><small>{Total}</small></div>
<div><small>{Tax}</small></div>
<div><small>{Security}</small></div>
<div><small>{Insurance}</small></div>
<div><small>{PaymentMethod}</small></div>
<div><small>{CancelURL}</small></div>
 </div>
', 'script');


INSERT INTO `plugin_base_fields` VALUES (NULL, 'notifications_ARRAY_admin_sms_confirmation', 'arrays', 'Notifications / New reservation sms', 'script', '2018-05-31 06:20:44');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'New reservation sms', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'notifications_titles_ARRAY_admin_sms_confirmation', 'arrays', 'Notifications / New reservation sms (title)', 'script', '2018-05-31 06:59:17');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'New Booking Received sms sent to Admin', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'notifications_subtitles_ARRAY_admin_sms_confirmation', 'arrays', 'Notifications / New reservation sms (sub-title)', 'script', '2018-05-31 07:02:28');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'This message is sent to the administrator when a new reservation is made.', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'notifications_ARRAY_admin_sms_payment', 'arrays', 'Notifications / New payment sms', 'script', '2018-05-31 06:20:44');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'New payment sms', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'notifications_titles_ARRAY_admin_sms_payment', 'arrays', 'Notifications / New payment sms (title)', 'script', '2018-05-31 06:59:17');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Send Payment Confirmation sms sent to Admin', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'notifications_subtitles_ARRAY_admin_sms_payment', 'arrays', 'Notifications / New payment sms (sub-title)', 'script', '2018-05-31 07:02:28');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'This message is sent to the administrator when a payment for a new reservation is made.', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'error_titles_ARRAY_AO26', 'arrays', 'error_titles_ARRAY_AO26', 'script', '2013-09-18 08:44:51');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Terms', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'error_bodies_ARRAY_AO26', 'arrays', 'error_bodies_ARRAY_AO26', 'script', '2013-09-18 08:45:51');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Enter booking terms and conditions.', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'error_bodies_ARRAY_AO09', 'arrays', 'error_bodies_ARRAY_AO09', 'script', '2013-10-07 11:42:11');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'All the changes made to terms have been saved.', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'error_titles_ARRAY_AO09', 'arrays', 'error_titles_ARRAY_AO09', 'script', '2013-10-07 11:42:21');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Terms updated!', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'notifications_ARRAY_client_sms_reminder', 'arrays', 'Notifications / Reservation reminder SMS', 'script', '2018-05-31 06:20:44');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Reservation reminder SMS', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'notifications_titles_ARRAY_client_sms_reminder', 'arrays', 'Notifications / Reservation reminder SMS (title)', 'script', '2018-05-31 06:59:17');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Send Reservation Reminder sms sent to Client', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'notifications_subtitles_ARRAY_client_sms_reminder', 'arrays', 'Notifications / Reservation reminder SMS (sub-title)', 'script', '2018-05-31 07:02:28');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'You can send SMS message under the Edit Reservation page', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjAdminExtras', 'backend', 'pjAdminExtras', 'script', '2015-03-20 11:37:44');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Extras Menu', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjAdminExtras_pjActionIndex', 'backend', 'pjAdminExtras_pjActionIndex', 'script', '2015-03-20 11:37:44');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Extras List', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjAdminExtras_pjActionCreate', 'backend', 'pjAdminExtras_pjActionCreate', 'script', '2015-03-20 11:37:44');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Add extra', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjAdminExtras_pjActionUpdate', 'backend', 'pjAdminExtras_pjActionUpdate', 'script', '2015-03-20 11:37:44');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Update extra', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjAdminExtras_pjActionDelete', 'backend', 'pjAdminExtras_pjActionDelete', 'script', '2015-03-20 11:37:44');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Delete single extra', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjAdminExtras_pjActionDeleteBulk', 'backend', 'pjAdminExtras_pjActionDeleteBulk', 'script', '2015-03-20 11:37:44');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Delete multiple extras', 'script');


INSERT INTO `plugin_auth_permissions` (`id`, `parent_id`, `key`) VALUES (NULL, NULL, 'pjAdminExtras');
SET @level_1_id := (SELECT LAST_INSERT_ID());

  INSERT INTO `plugin_auth_permissions` (`id`, `parent_id`, `key`) VALUES (NULL, @level_1_id, 'pjAdminExtras_pjActionIndex');
  SET @level_2_id := (SELECT LAST_INSERT_ID());

    INSERT INTO `plugin_auth_permissions` (`id`, `parent_id`, `key`) VALUES (NULL, @level_2_id, 'pjAdminExtras_pjActionCreate');
    INSERT INTO `plugin_auth_permissions` (`id`, `parent_id`, `key`) VALUES (NULL, @level_2_id, 'pjAdminExtras_pjActionUpdate');
    INSERT INTO `plugin_auth_permissions` (`id`, `parent_id`, `key`) VALUES (NULL, @level_2_id, 'pjAdminExtras_pjActionDelete');
    INSERT INTO `plugin_auth_permissions` (`id`, `parent_id`, `key`) VALUES (NULL, @level_2_id, 'pjAdminExtras_pjActionDeleteBulk');
    

INSERT INTO `plugin_base_fields` VALUES (NULL, 'lblInstallJs1_title', 'backend', 'Install / Title', 'script', '2013-09-18 13:30:03');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Install instructions', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'lblInstallJs1_body', 'backend', 'Install / Body', 'script', '2013-09-18 13:30:14');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'In order to install the script on your website copy the code below and add it to your web page.', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'lblInstallJs1_1', 'backend', 'Install / Step 1', 'script', '2013-09-18 13:30:26');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Install Code', 'script');
  
INSERT INTO `plugin_base_fields` VALUES (NULL, 'lblInstallLanguageConfig', 'backend', 'Install / Language configuration', 'script', '2013-09-18 13:30:03');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Language configuration', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'lblInstallConfigLocale', 'backend', 'Install / Language', 'script', '2013-09-18 13:30:03');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Language', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'lblInstallCodeStep1', 'backend', 'Install / Step 1', 'script', '2013-09-18 13:30:03');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Step 1. (Required) Copy the code below and put it in the HEAD tag of your web page.', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'lblInstallCodeStep2', 'backend', 'Install / Step 2', 'script', '2013-09-18 13:30:03');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Step 2. (Required) Copy the code below and put it in your web page where you want the script to appear.', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'prices_invalid_input', 'backend', 'Label / The price value cannot be greater than 9999999.99', 'script', '2018-11-19 07:06:08');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'The price value cannot be greater than 9999999.99', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'delete_selected', 'backend', 'Grid / Delete selected', 'script', '2013-09-16 14:10:00');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Delete selected', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'delete_confirmation', 'backend', 'Grid / Confirmation Title', 'script', '2013-09-16 14:09:36');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Are you sure you want to delete selected records?', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'error_titles_ARRAY_AT12', 'arrays', 'error_titles_ARRAY_AT12', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Picture size is too large', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'error_bodies_ARRAY_AT12', 'arrays', 'error_bodies_ARRAY_AT12', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'New type could not be added because picture size is too large and your server cannot upload it. Maximum allowed size is {SIZE}. Please, upload smaller picture.', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'error_titles_ARRAY_AT13', 'arrays', 'error_titles_ARRAY_AT13', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Picture size exceeded', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'error_bodies_ARRAY_AT13', 'arrays', 'error_bodies_ARRAY_AT13', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'New type has been added, but picture could not be uploaded as its size exceeds the maximum allowed file upload size.', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'error_titles_ARRAY_AT14', 'arrays', 'error_titles_ARRAY_AT14', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Wrong file type', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'error_bodies_ARRAY_AT14', 'arrays', 'error_bodies_ARRAY_AT14', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'You uploaded picture is not allowed to upload because it''s in wrong content type. Please check the actual type of the file.', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'error_titles_ARRAY_AT15', 'arrays', 'error_titles_ARRAY_AT15', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Picture size is too large', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'error_bodies_ARRAY_AT15', 'arrays', 'error_bodies_ARRAY_AT15', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Type could not be updated because picture size is too large and your server cannot upload it. Maximum allowed size is {SIZE}. Please, upload smaller picture.', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'error_titles_ARRAY_AT16', 'arrays', 'error_titles_ARRAY_AT16', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Picture size exceeded', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'error_bodies_ARRAY_AT16', 'arrays', 'error_bodies_ARRAY_AT16', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Type information has been updated, but picture could not be uploaded as its size exceeds the maximum allowed file upload size.', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'error_titles_ARRAY_AT17', 'arrays', 'error_titles_ARRAY_AT17', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Wrong file type', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'error_bodies_ARRAY_AT17', 'arrays', 'error_bodies_ARRAY_AT17', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'You uploaded picture is not allowed to upload because it''s in wrong content type. Please check the actual type of the file.', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'btn_select_image', 'backend', 'Label / Select image', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Select image', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'btn_change_image', 'backend', 'Label / Change image', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Change image', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'type_image_dtitle', 'backend', 'Types / Delete confirmation', 'script', '2013-09-18 11:23:07');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Delete confirmation', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'type_image_dbody', 'backend', 'Types / Delete content', 'script', '2013-09-18 11:23:46');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Are you sure you want to delete this picture?', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'btnAddRate', 'backend', 'Button / Add rate', 'script', '2013-09-18 11:23:07');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Add rate', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'lblDuplicatedPeriodTitle', 'backend', 'Label / Duplicated period', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Duplicated period', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'lblDuplicatedPeriodDesc', 'backend', 'Label / Duplicated period', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'You have set the same period for the same rate. Please check again.', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'btnOk', 'backend', 'Button / OK', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'OK', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'lblEmptyRatesTitle', 'backend', 'Label / Warning', 'script', '2016-01-11 03:17:24');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Warning', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'lblEmptyRatesDesc', 'backend', 'Label / Warning desc', 'script', '2016-01-11 03:17:53');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Please set your custom rates', 'script');


INSERT INTO `plugin_auth_permissions` (`id`, `parent_id`, `key`) VALUES (NULL, NULL, 'pjAdminLocations');
SET @level_1_id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @level_1_id, 'pjAuthPermission', '::LOCALE::', 'title', 'Office Locations menu', 'data');

  INSERT INTO `plugin_auth_permissions` (`id`, `parent_id`, `key`) VALUES (NULL, @level_1_id, 'pjAdminLocations_pjActionIndex');
  SET @level_2_id := (SELECT LAST_INSERT_ID());
  INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @level_2_id, 'pjAuthPermission', '::LOCALE::', 'title', 'Office Locations List', 'data');

    INSERT INTO `plugin_auth_permissions` (`id`, `parent_id`, `key`) VALUES (NULL, @level_2_id, 'pjAdminLocations_pjActionCreate');
    SET @level_3_id := (SELECT LAST_INSERT_ID());
    INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @level_3_id, 'pjAuthPermission', '::LOCALE::', 'title', 'Add location', 'data');

    INSERT INTO `plugin_auth_permissions` (`id`, `parent_id`, `key`) VALUES (NULL, @level_2_id, 'pjAdminLocations_pjActionUpdate');
    SET @level_3_id := (SELECT LAST_INSERT_ID());
    INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @level_3_id, 'pjAuthPermission', '::LOCALE::', 'title', 'Edit location', 'data');

    INSERT INTO `plugin_auth_permissions` (`id`, `parent_id`, `key`) VALUES (NULL, @level_2_id, 'pjAdminLocations_pjActionDelete');
    SET @level_3_id := (SELECT LAST_INSERT_ID());
    INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @level_3_id, 'pjAuthPermission', '::LOCALE::', 'title', 'Delete single location', 'data');

    INSERT INTO `plugin_auth_permissions` (`id`, `parent_id`, `key`) VALUES (NULL, @level_2_id, 'pjAdminLocations_pjActionDeleteBulk');
    SET @level_3_id := (SELECT LAST_INSERT_ID());
    INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @level_3_id, 'pjAuthPermission', '::LOCALE::', 'title', 'Delete multiple locations', 'data');

    INSERT INTO `plugin_auth_permissions` (`id`, `parent_id`, `key`, `is_shown`) VALUES (NULL, @level_2_id, 'pjAdminLocations_pjActionGet', 'F');
    SET @level_3_id := (SELECT LAST_INSERT_ID());
    INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @level_3_id, 'pjAuthPermission', '::LOCALE::', 'title', 'Show list elements', 'data');

    INSERT INTO `plugin_auth_permissions` (`id`, `parent_id`, `key`, `is_shown`) VALUES (NULL, @level_2_id, 'pjAdminLocations_pjActionSave', 'F');
    SET @level_3_id := (SELECT LAST_INSERT_ID());
    INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @level_3_id, 'pjAuthPermission', '::LOCALE::', 'title', 'Save location', 'data');

  INSERT INTO `plugin_auth_permissions` (`id`, `parent_id`, `key`) VALUES (NULL, @level_1_id, 'pjAdminTime_pjActionIndex');
  SET @level_2_id := (SELECT LAST_INSERT_ID());
  INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @level_2_id, 'pjAuthPermission', '::LOCALE::', 'title', 'Working Time Menu', 'data');

    INSERT INTO `plugin_auth_permissions` (`id`, `parent_id`, `key`) VALUES (NULL, @level_2_id, 'pjAdminTime_pjActionSetTime');
    SET @level_3_id := (SELECT LAST_INSERT_ID());
    INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @level_3_id, 'pjAuthPermission', '::LOCALE::', 'title', 'Create Working Time', 'data');

    INSERT INTO `plugin_auth_permissions` (`id`, `parent_id`, `key`, `is_shown`) VALUES (NULL, @level_2_id, 'pjAdminTime_pjActionSaveTime', 'F');
    SET @level_3_id := (SELECT LAST_INSERT_ID());
    INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @level_3_id, 'pjAuthPermission', '::LOCALE::', 'title', 'Save time', 'data');

    INSERT INTO `plugin_auth_permissions` (`id`, `parent_id`, `key`) VALUES (NULL, @level_2_id, 'pjAdminTime_pjActionGetDayOff');
    SET @level_3_id := (SELECT LAST_INSERT_ID());
    INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @level_3_id, 'pjAuthPermission', '::LOCALE::', 'title', 'Custom Working Time', 'data');

    INSERT INTO `plugin_auth_permissions` (`id`, `parent_id`, `key`, `is_shown`) VALUES (NULL, @level_2_id, 'pjAdminTime_pjActionCheckDayOff', 'F');
    SET @level_3_id := (SELECT LAST_INSERT_ID());
    INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @level_3_id, 'pjAuthPermission', '::LOCALE::', 'title', 'Check day off', 'data');

    INSERT INTO `plugin_auth_permissions` (`id`, `parent_id`, `key`) VALUES (NULL, @level_2_id, 'pjAdminTime_pjActionSetDayOff');
    SET @level_3_id := (SELECT LAST_INSERT_ID());
    INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @level_3_id, 'pjAuthPermission', '::LOCALE::', 'title', 'Create/Update Custom Working Time', 'data');

    INSERT INTO `plugin_auth_permissions` (`id`, `parent_id`, `key`) VALUES (NULL, @level_2_id, 'pjAdminTime_pjActionDeleteDayOff');
    SET @level_3_id := (SELECT LAST_INSERT_ID());
    INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @level_3_id, 'pjAuthPermission', '::LOCALE::', 'title', 'Delete single Custom Working Time', 'data');

    INSERT INTO `plugin_auth_permissions` (`id`, `parent_id`, `key`) VALUES (NULL, @level_2_id, 'pjAdminTime_pjActionDeleteDayOffBulk');
    SET @level_3_id := (SELECT LAST_INSERT_ID());
    INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @level_3_id, 'pjAuthPermission', '::LOCALE::', 'title', 'Delete Multiple Custom Working Times', 'data');

    INSERT INTO `plugin_auth_permissions` (`id`, `parent_id`, `key`, `is_shown`) VALUES (NULL, @level_2_id, 'pjAdminTime_pjActionGetUpdate', 'F');
    SET @level_3_id := (SELECT LAST_INSERT_ID());
    INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @level_3_id, 'pjAuthPermission', '::LOCALE::', 'title', 'Get Update', 'data');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjAdminLocations', 'backend', 'Label / Locations menu', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Office Locations menu', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjAdminLocations_pjActionIndex', 'backend', 'Label / Office Locations List', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Office Locations List', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjAdminLocations_pjActionCreate', 'backend', 'Label / Add location', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Add location', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjAdminLocations_pjActionUpdate', 'backend', 'Label / Edit location', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Edit location', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjAdminLocations_pjActionDelete', 'backend', 'Label / Delete single location', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Delete single location', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjAdminLocations_pjActionDeleteBulk', 'backend', 'Label / Delete multiple locations', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Delete multiple locations', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjAdminLocations_pjActionGet', 'backend', 'Label / Get location', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Show list elements', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjAdminLocations_pjActionSave', 'backend', 'Label / Get location', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Save location', 'script');


SET @id := (SELECT `id` FROM `plugin_base_fields` WHERE `key`='btnAddLocation');
UPDATE `plugin_base_multi_lang` SET `content`='Add location' WHERE `foreign_id`=@id AND `model`='pjField' AND `field`='title';

INSERT INTO `plugin_base_fields` VALUES (NULL, '_notify_email_ARRAY_T', 'arrays', '_notify_email_ARRAY_T', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Yes', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, '_notify_email_ARRAY_F', 'arrays', '_notify_email_ARRAY_F', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'No', 'script');


INSERT INTO `plugin_base_fields` VALUES (NULL, 'error_titles_ARRAY_AL12', 'arrays', 'error_titles_ARRAY_AL12', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Picture size is too large', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'error_bodies_ARRAY_AL12', 'arrays', 'error_bodies_ARRAY_AL12', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'New location could not be added because picture size is too large and your server cannot upload it. Maximum allowed size is {SIZE}. Please, upload smaller picture.', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'error_titles_ARRAY_AL13', 'arrays', 'error_titles_ARRAY_AL13', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Picture size exceeded', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'error_bodies_ARRAY_AL13', 'arrays', 'error_bodies_ARRAY_AL13', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'New location has been added, but picture could not be uploaded as its size exceeds the maximum allowed file upload size.', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'error_titles_ARRAY_AL14', 'arrays', 'error_titles_ARRAY_AL14', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Wrong file type', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'error_bodies_ARRAY_AL14', 'arrays', 'error_bodies_ARRAY_AL14', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'You uploaded picture is not allowed to upload because it''s in wrong content type. Please check the actual type of the file.', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'error_titles_ARRAY_AL15', 'arrays', 'error_titles_ARRAY_AL15', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Picture size is too large', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'error_bodies_ARRAY_AL15', 'arrays', 'error_bodies_ARRAY_AL15', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Location could not be updated because picture size is too large and your server cannot upload it. Maximum allowed size is {SIZE}. Please, upload smaller picture.', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'error_titles_ARRAY_AL16', 'arrays', 'error_titles_ARRAY_AL16', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Picture size exceeded', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'error_bodies_ARRAY_AL16', 'arrays', 'error_bodies_ARRAY_AL16', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Location information has been updated, but picture could not be uploaded as its size exceeds the maximum allowed file upload size.', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'error_titles_ARRAY_AL17', 'arrays', 'error_titles_ARRAY_AL17', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Wrong file type', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'error_bodies_ARRAY_AL17', 'arrays', 'error_bodies_ARRAY_AL17', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'You uploaded picture is not allowed to upload because it''s in wrong content type. Please check the actual type of the file.', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'location_image_dtitle', 'backend', 'Types / Delete confirmation', 'script', '2013-09-18 11:23:07');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Delete confirmation', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'location_image_dbody', 'backend', 'Types / Delete content', 'script', '2013-09-18 11:23:46');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Are you sure you want to delete this picture?', 'script');


INSERT INTO `plugin_base_fields` VALUES (NULL, 'tab_default', 'backend', 'Label / Tab / Default', 'script', '2017-12-22 08:14:59');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Default', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'tab_days_off', 'backend', 'Label / Tab / Days off', 'script', '2017-12-22 08:15:19');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Days off', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'btn_set_wtime', 'backend', 'Label / Button / Set Working Times', 'script', '2017-12-22 08:17:52');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Set Working Times', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'day', 'backend', 'Label / Button / Day', 'script', '2017-12-28 08:04:44');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Day', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'hours', 'backend', 'Label / Hours', 'script', '2017-12-22 08:18:39');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Working hours', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'lunch_break', 'backend', 'Label / Lunch break', 'script', '2017-12-22 08:18:39');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Lunch break', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'day_off', 'backend', 'Label / Button / Day off', 'script', '2017-12-22 08:26:13');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Day off', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'lunch_off', 'backend', 'Label / Button / Lunch off', 'script', '2017-12-22 08:26:13');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Lunch off', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'set_working_times', 'backend', 'Label / Set Working Times', 'script', '2017-12-22 08:48:27');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Set Working Times', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'select_day', 'backend', 'Label / Select day', 'script', '2017-12-22 08:48:53');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Select day', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'choose', 'backend', 'Label / Choose', 'script', '2017-12-22 08:52:54');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Choose', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'btn_cancel', 'backend', 'Label / Button / Cancel', 'script', '2017-12-22 08:58:42');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Cancel', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'wokring_from', 'backend', 'Label / Working Time From', 'script', '2017-12-22 08:59:43');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Working Time From', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'wokring_to', 'backend', 'Label / Working Time To', 'script', '2017-12-22 08:59:55');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Working Time To', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'from', 'backend', 'Label / Working Time From', 'script', '2017-12-22 08:59:43');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'From', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'to', 'backend', 'Label / Working Time To', 'script', '2017-12-22 08:59:55');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'To', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'lunch_from', 'backend', 'Label / Lunch Break From', 'script', '2017-12-22 08:59:43');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Lunch Break From', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'lunch_to', 'backend', 'Label / Lunch Break To', 'script', '2017-12-22 08:59:55');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Lunch Break To', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'invalid_selected_time', 'backend', 'Label / End time cannot be less than start time.', 'script', '2017-12-22 10:41:16');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Working Time From must precede Working Time To', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'duplicated_time', 'backend', 'Label / Duplicated time on weekday', 'script', '2017-12-28 02:23:43');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Duplicated time on %s.', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'error_titles_ARRAY_PAMT01', 'arrays', 'error_titles_ARRAY_PAMT01', 'script', '2017-12-28 02:55:58');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Working Time Updated!', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'error_bodies_ARRAY_PAMT01', 'arrays', 'error_bodies_ARRAY_PAMT01', 'script', '2017-12-28 02:56:34');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'All changes made to the default working time have been saved successfully. ', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'btn_add_day_off', 'backend', 'Label / Button / Add Day Off', 'script', '2017-12-28 03:22:39');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Add Day Off', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'add_day_off', 'backend', 'Label / Add Day Off', 'script', '2017-12-28 03:24:07');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Add custom working time', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'from_date', 'backend', 'Label / From date', 'script', '2017-12-28 03:24:36');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'From Date', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'to_date', 'backend', 'Label / To date', 'script', '2017-12-28 03:24:54');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'To Date', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'from_time', 'backend', 'Label / From time', 'script', '2017-12-28 03:25:20');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'From Time', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'to_time', 'backend', 'Label / To time', 'script', '2017-12-28 03:25:41');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'To Time', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'dates', 'backend', 'Label / Date(s)', 'script', '2017-12-28 03:35:47');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Date(s)', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'hour', 'backend', 'Label / Hour', 'script', '2017-12-28 03:36:13');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Hour', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'all_day', 'backend', 'Label / All day', 'script', '2017-12-28 03:47:05');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'All day', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'invalid_dates_off', 'backend', 'Label / From date must be less than To date.', 'script', '2017-12-28 04:17:52');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'From Date must precede To Date', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'invalid_day_off_time', 'backend', 'Label / From time must be less than To time.', 'script', '2017-12-28 04:20:48');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'From Time must precede To Time', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'error_titles_ARRAY_AWT04', 'arrays', 'error_titles_ARRAY_AWT04', 'script', '2013-09-17 07:45:33');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Working Time', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'error_bodies_ARRAY_AWT04', 'arrays', 'error_bodies_ARRAY_AWT04', 'script', '2013-12-12 18:48:05');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Different working time can be set for each day of the week. You can also set days off and a lunch break. Under Edit Location page you can set up custom working time for each of your locations.', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'time_update_custom', 'backend', 'Working Time / Update custom', 'script', '2013-09-17 07:47:22');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Update custom', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'time_default', 'backend', 'Working Time / Default', 'script', '2013-09-17 08:42:14');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Default', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'location_address', 'backend', 'Location / Address', 'script', '2013-09-17 08:41:28');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Address', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'time_default_wt', 'backend', 'Working Time / Default Working Time', 'script', '2013-09-17 08:42:43');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Default Working Time', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'time_custom_wt', 'backend', 'Working Time / Custom Working Time', 'script', '2013-09-17 08:42:55');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Custom Working Time', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'time_lunch_from', 'backend', 'Working Time / Lunch from', 'script', '2013-09-17 10:28:54');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Lunch from', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'time_lunch_to', 'backend', 'Working Time / Lunch to', 'script', '2013-09-17 10:29:07');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Lunch to', 'script');


    

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjAdminTime', 'backend', 'Label / Working Time Menu', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Working Time Menu', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjAdminTime_pjActionIndex', 'backend', 'Label / Default Working Time', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Default Working Time', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjAdminTime_pjActionSetTime', 'backend', 'Label / Set time', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Create Working Time', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjAdminTime_pjActionSaveTime', 'backend', 'Label / Save time', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Save time', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjAdminTime_pjActionGetDayOff', 'backend', 'Label / Get day off', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Custom Working Time', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjAdminTime_pjActionCheckDayOff', 'backend', 'Label / Check day off', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Check day off', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjAdminTime_pjActionSetDayOff', 'backend', 'Label / Set day off', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Create/Update Custom Working Time', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjAdminTime_pjActionDeleteDayOff', 'backend', 'Label / Delete day off', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Delete single Custom Working Time', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjAdminTime_pjActionDeleteDayOffBulk', 'backend', 'Label / Delete day off bulk', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Delete Multiple Custom Working Times', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjAdminTime_pjActionGetUpdate', 'backend', 'Label / Get Update', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Update Custom Working Time', 'script');


INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjAdminCars', 'backend', 'pjAdminCars', 'script', '2015-03-20 11:37:44');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Cars Menu', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjAdminCars_pjActionIndex', 'backend', 'pjAdminCars_pjActionIndex', 'script', '2015-03-20 11:37:44');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Cars List', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjAdminCars_pjActionCreate', 'backend', 'pjAdminCars_pjActionCreate', 'script', '2015-03-20 11:37:44');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Add car', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjAdminCars_pjActionUpdate', 'backend', 'pjAdminCars_pjActionUpdate', 'script', '2015-03-20 11:37:44');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Update car', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjAdminCars_pjActionDelete', 'backend', 'pjAdminCars_pjActionDelete', 'script', '2015-03-20 11:37:44');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Delete single car', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjAdminCars_pjActionDeleteBulk', 'backend', 'pjAdminCars_pjActionDeleteBulk', 'script', '2015-03-20 11:37:44');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Delete multiple cars', 'script');


INSERT INTO `plugin_auth_permissions` (`id`, `parent_id`, `key`) VALUES (NULL, NULL, 'pjAdminCars');
SET @level_1_id := (SELECT LAST_INSERT_ID());

  INSERT INTO `plugin_auth_permissions` (`id`, `parent_id`, `key`) VALUES (NULL, @level_1_id, 'pjAdminCars_pjActionIndex');
  SET @level_2_id := (SELECT LAST_INSERT_ID());

    INSERT INTO `plugin_auth_permissions` (`id`, `parent_id`, `key`) VALUES (NULL, @level_2_id, 'pjAdminCars_pjActionCreate');
    INSERT INTO `plugin_auth_permissions` (`id`, `parent_id`, `key`) VALUES (NULL, @level_2_id, 'pjAdminCars_pjActionUpdate');
    INSERT INTO `plugin_auth_permissions` (`id`, `parent_id`, `key`) VALUES (NULL, @level_2_id, 'pjAdminCars_pjActionDelete');
    INSERT INTO `plugin_auth_permissions` (`id`, `parent_id`, `key`) VALUES (NULL, @level_2_id, 'pjAdminCars_pjActionDeleteBulk');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjAdminBookings', 'backend', 'pjAdminBookings', 'script', '2015-03-20 11:37:44');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Reservations Menu', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjAdminBookings_pjActionIndex', 'backend', 'pjAdminBookings_pjActionIndex', 'script', '2015-03-20 11:37:44');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Reservations List', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjAdminBookings_pjActionCreate', 'backend', 'pjAdminBookings_pjActionCreate', 'script', '2015-03-20 11:37:44');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Add reservation', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjAdminBookings_pjActionUpdate', 'backend', 'pjAdminBookings_pjActionUpdate', 'script', '2015-03-20 11:37:44');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Update reservation', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjAdminBookings_pjActionDeleteBooking', 'backend', 'pjAdminBookings_pjActionDeleteBooking', 'script', '2015-03-20 11:37:44');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Delete single reservation', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjAdminBookings_pjActionDeleteBookingBulk', 'backend', 'pjAdminBookings_pjActionDeleteBookingBulk', 'script', '2015-03-20 11:37:44');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Delele multiple reservations', 'script');

INSERT INTO `plugin_auth_permissions` (`id`, `parent_id`, `key`) VALUES (NULL, NULL, 'pjAdminBookings');
SET @level_1_id := (SELECT LAST_INSERT_ID());

  INSERT INTO `plugin_auth_permissions` (`id`, `parent_id`, `key`) VALUES (NULL, @level_1_id, 'pjAdminBookings_pjActionIndex');
  SET @level_2_id := (SELECT LAST_INSERT_ID());
  
    INSERT INTO `plugin_auth_permissions` (`id`, `parent_id`, `key`) VALUES (NULL, @level_2_id, 'pjAdminBookings_pjActionCreate');
    INSERT INTO `plugin_auth_permissions` (`id`, `parent_id`, `key`) VALUES (NULL, @level_2_id, 'pjAdminBookings_pjActionUpdate');
    INSERT INTO `plugin_auth_permissions` (`id`, `parent_id`, `key`) VALUES (NULL, @level_2_id, 'pjAdminBookings_pjActionDeleteBooking');
    INSERT INTO `plugin_auth_permissions` (`id`, `parent_id`, `key`) VALUES (NULL, @level_2_id, 'pjAdminBookings_pjActionDeleteBookingBulk');

    

INSERT INTO `plugin_base_fields` VALUES (NULL, 'advance_search', 'backend', 'Label / Advance Search', 'script', '2015-03-20 11:37:44');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Advance Search', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'label_to', 'backend', 'Label / to', 'script', '2015-03-20 11:37:44');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'to', 'script');
  

SET @id := (SELECT `id` FROM `plugin_base_fields` WHERE `key`='btnAddReservation');
UPDATE `plugin_base_multi_lang` SET `content`='Add reservation' WHERE `foreign_id`=@id AND `model`='pjField' AND `field`='title';
 
SET @id := (SELECT `id` FROM `plugin_base_fields` WHERE `key`='infoAddBookingTitle');
UPDATE `plugin_base_multi_lang` SET `content`='Add new reservation' WHERE `foreign_id`=@id AND `model`='pjField' AND `field`='title';
    
SET @id := (SELECT `id` FROM `plugin_base_fields` WHERE `key`='infoAddBookingBody');
UPDATE `plugin_base_multi_lang` SET `content`='Use the form below to manually add new reservation. You need to fill in the required data in both tabs - Rental details and Customer details. The system will automatically calculate the price based on your selection.' WHERE `foreign_id`=@id AND `model`='pjField' AND `field`='title';

INSERT INTO `plugin_base_fields` VALUES (NULL, 'lblExtra', 'backend', 'Label / Extra', 'script', '2015-03-20 11:37:44');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Extra', 'script');
  
INSERT INTO `plugin_base_fields` VALUES (NULL, 'lblPrice', 'backend', 'Label / Price', 'script', '2015-03-20 11:37:44');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Price', 'script');
  
INSERT INTO `plugin_base_fields` VALUES (NULL, 'lblQty', 'backend', 'Label / Qty', 'script', '2015-03-20 11:37:44');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Qty', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'btnBookingAddExtra', 'backend', 'Button / Add extra', 'script', '2015-03-20 11:37:44');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Add extra', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'infoUpdateBookingTitle', 'backend', 'Info / Update booking title', 'script', '2015-03-20 11:37:44');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Update booking', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'infoUpdateBookingDesc', 'backend', 'Info / Update booking body', 'script', '2015-03-20 11:37:44');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Use the form below to update booking details.', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'btnBookingAddPayment', 'backend', 'Button / Add payment', 'script', '2015-03-20 11:37:44');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Add payment', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'booking_payment_dtitle', 'backend', 'Info / Delete payment title', 'script', '2015-03-20 11:37:44');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Delete payment', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'booking_payment_dbody', 'backend', 'Info / Delete payment body', 'script', '2015-03-20 11:37:44');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Are you sure you want to delete this payment?', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'booking_c_email', 'backend', 'Label / Email', 'script', '2015-03-20 11:37:44');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Email', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'booking_email_confirmation', 'backend', 'Info / Email confirmation', 'script', '2015-03-20 11:37:44');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Email confirmation', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'booking_sms_confirmation', 'backend', 'Info / SMS confirmation', 'script', '2015-03-20 11:37:44');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'SMS confirmation', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'lblEmailNotificationNotSet', 'backend', 'Email / Email notificaton has not been set', 'script', '2015-03-20 11:37:44');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Email notificaton has not been set', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'lblSmsNotificationNotSet', 'backend', 'Email / SMS notificaton has not been set', 'script', '2015-03-20 11:37:44');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'SMS notificaton has not been set', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'label_today', 'backend', 'Label / Today', 'script', '2015-03-20 11:37:44');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Today', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'lblDashTotalBookingToday', 'backend', 'Label / Total booking today', 'script', '2015-03-20 11:37:44');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Total <strong>%s</strong> booking today', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'lblDashTotalBookingsToday', 'backend', 'Label / Total booking today', 'script', '2015-03-20 11:37:44');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Total <strong>%s</strong> bookings today', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'lblDashTotalPickupToday', 'backend', 'Label / Total pickup today', 'script', '2015-03-20 11:37:44');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Total <strong>%s</strong> pick-up today', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'lblDashTotalReturnToday', 'backend', 'Label / Total return today', 'script', '2015-03-20 11:37:44');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Total <strong>%s</strong> return today', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'lblDashNoBookingsFound', 'backend', 'Label / No bookings found', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'No bookings found', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'lblDashNoCarsFound', 'backend', 'Label / No cars found', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'No cars found', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'lblOptionsTermsContent', 'backend', 'Options / Booking terms content', 'script', '2013-09-18 06:54:03');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Booking terms content', 'script');

INSERT INTO `fields` VALUES (NULL, 'wtime_arr_ARRAY_8', 'arrays', 'wtime_arr_ARRAY_8', 'script', '2016-03-11 09:56:27');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Office is on lunch break', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'front_booking_success', 'backend', 'Frontend / Booking success', 'script', '2015-03-20 11:37:44');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Your reservation has been successfully sent to the administrator.', 'script');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'cancel_title', 'frontend', 'Cancel / Page title', 'script', '2014-01-22 08:43:29');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Booking Cancellation', 'script');

SET @id := (SELECT `id` FROM `plugin_base_fields` WHERE `key`='opt_o_thankyou_page_text');
UPDATE `plugin_base_multi_lang` SET `content`='Enter the URL your customers will be redirected to after online payment.' WHERE `foreign_id`=@id AND `model`='pjField' AND `field`='title';



COMMIT;