<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjAdminOptions extends pjAdmin
{
	public function pjActionBooking()
	{
		if (!pjAuth::factory()->hasAccess())
		{
			$this->sendForbidden();
			return;
		}
		
		$pjOptionModel = pjOptionModel::factory();
		
		$arr = $pjOptionModel
				->where('t1.foreign_id', $this->getForeignId())
				->where('t1.tab_id', 1)
				->orderBy('t1.order ASC')
				->findAll()
				->getData();
	
		$this->set('arr', $arr);
		
		$tmp = $pjOptionModel->reset()->where('foreign_id', $this->getForeignId())->findAll()->getData();
		$o_arr = array();
		foreach ($tmp as $item)
		{
			$o_arr[$item['key']] = $item;
		}
		$this->set('o_arr', $o_arr);
		
		$this->appendJs('pjAdminOptions.js');
	}
	
	public function pjActionBookingForm()
	{
		if (!pjAuth::factory()->hasAccess())
		{
			$this->sendForbidden();
			return;
		}
		
		$arr = pjOptionModel::factory()
		->where('t1.foreign_id', $this->getForeignId())
		->where('t1.tab_id', 2)
		->orderBy('t1.order ASC')
		->findAll()
		->getData();
	
		$this->set('arr', $arr);
		$this->appendJs('pjAdminOptions.js');
	}
	
	public function pjActionInstall()
	{
		if (!pjAuth::factory()->hasAccess())
		{
			$this->sendForbidden();
			return;
		}
		
		$this->set('is_flag_ready', $this->requestAction(array('controller' => 'pjLocale', 'action' => 'pjActionIsFlagReady'), array('return')));
		$locale_arr = pjBaseLocaleModel::factory()
			->select('t1.*, t2.file, t2.title')
			->join('pjBaseLocaleLanguage', 't2.iso=t1.language_iso', 'left')
			->where('t2.file IS NOT NULL')
			->orderBy('t1.sort ASC')
			->findAll()
			->getData();
		$this->set('locale_arr', $locale_arr);
				
		$this->appendJs('pjAdminOptions.js');
	}
	
	public function pjActionPayments()
	{
		if (!pjAuth::factory()->hasAccess())
		{
			$this->sendForbidden();
			return;
		}
		
		$pjOptionModel = pjOptionModel::factory();
		$arr = $pjOptionModel
				->where('t1.foreign_id', $this->getForeignId())
				->where('tab_id', 2)
				->orderBy('t1.order ASC')
				->findAll()
				->getData();
		$key_arr = 	$pjOptionModel->getDataPair('key');
	
		$this->set('arr', $arr);
		$this->set('key_arr', $key_arr);
		$this->set('o_arr', $pjOptionModel->reset()->getPairs($this->getForeignId()));
	
		$this->setLocalesData();
	
		$this->appendJs('jquery.multilang.js', $this->getConstant('pjBase', 'PLUGIN_JS_PATH'), false, false);
		$this->appendJs('pjAdminOptions.js');
	}
	
	public function pjActionPaymentOptions()
	{
		$this->checkLogin();
	
		$this->setAjax(true);
		
		if (self::isPost() && $this->_post->check('options_update'))
		{
			if (pjObject::getPlugin('pjPayments') !== NULL && $this->_post->check('plugin_payment_options'))
			{
				$this->requestAction(array(
						'controller' => 'pjPayments',
						'action' => 'pjActionSaveOptions',
						'params' => array(
						'foreign_id' => $this->getForeignId(),
						'data' => $this->_post->toArray('plugin_payment_options'),
						)
				), array('return'));
			}
			if(in_array($this->_post->toString('payment_method'), array('cash', 'bank')))
			{
				$pjOptionModel = new pjOptionModel();
				if($this->_post->toString('payment_method') == 'cash')
				{
					$k = 'o_allow_cash';
				}else{
					$k = 'o_allow_bank';
				}
				$value = $this->_post->toString($k) == '1' ? '1|0::1' : '1|0::0';
				$pjOptionModel
				->reset()->debug(1)
				->where('foreign_id', $this->getForeignId())
				->where('`key`', $k)
				->limit(1)
				->modifyAll(array('value' => $value));
			}
			if ($this->_post->check('i18n'))
			{
				pjMultiLangModel::factory()->updateMultiLang($this->_post->toI18n('i18n'), $this->getForeignId(), 'pjPayment', 'data');
			}
			if ($this->_post->check('i18n_options'))
			{
				pjMultiLangModel::factory()->updateMultiLang($this->_post->toI18n('i18n_options'), $this->getForeignId(), 'pjOption', 'data');
			}
		}
		
		if (self::isGet()) 
		{
			$this->set('i18n', pjMultiLangModel::factory()->getMultiLang($this->getForeignId(), 'pjPayment'));
			$this->set('i18n_options', pjMultiLangModel::factory()->getMultiLang($this->getForeignId(), 'pjOption'));
	
			$this->setLocalesData();
		}
	}
	
	public function pjActionNotifications()
	{
		if (!pjAuth::factory()->hasAccess())
		{
			$this->sendForbidden();
			return;
		}
		
		$arr = pjOptionModel::factory()
				->where('t1.foreign_id', $this->getForeignId())
				->where('t1.tab_id', 3)
				->orderBy('t1.order ASC')
				->findAll()
				->getData();
	
		$arr['i18n'] = pjMultiLangModel::factory()->getMultiLang($this->getForeignId(), 'pjOption');
	
		$this->set('arr', $arr);
	
		$this->setLocalesData();
	
		$this->appendCss('awesome-bootstrap-checkbox.css', PJ_THIRD_PARTY_PATH . 'awesome_bootstrap_checkbox/');
		$this->appendJs('jquery.multilang.js', $this->getConstant('pjBase', 'PLUGIN_JS_PATH'), false, false);
		$this->appendJs('tinymce.min.js', PJ_THIRD_PARTY_PATH . 'tinymce/');
		$this->appendJs('pjAdminOptions.js');
	}
	
	public function pjActionTerm()
	{
		if (!pjAuth::factory()->hasAccess())
		{
			$this->sendForbidden();
			return;
		}
		
		$arr = pjOptionModel::factory()
				->where('t1.foreign_id', $this->getForeignId())
				->where('t1.tab_id', 3)
				->orderBy('t1.order ASC')
				->findAll()
				->getData();
	
		$arr['i18n'] = pjMultiLangModel::factory()->getMultiLang($this->getForeignId(), 'pjOption');
	
		$this->set('arr', $arr);
	
		$this->setLocalesData();
	
		$this->appendJs('jquery.multilang.js', $this->getConstant('pjBase', 'PLUGIN_JS_PATH'), false, false);
		$this->appendJs('tinymce.min.js', PJ_THIRD_PARTY_PATH . 'tinymce/');
		$this->appendJs('pjAdminOptions.js');
	}
	
	public function pjActionPreview()
	{
		$this->appendJs('pjAdminOptions.js');
	}
	
	public function pjActionUpdate()
	{
		$this->checkLogin();

		if (!pjAuth::factory()->hasAccess())
		{
			$this->sendForbidden();
			return;
		}
		
		if (self::isPost() && $this->_post->toInt('options_update'))
		{
			$pjOptionModel = new pjOptionModel();
			$pjOptionModel
				->where('foreign_id', $this->getForeignId())
				->where('type', 'bool')
				->where('tab_id', $this->_post->toInt('tab'))
				->modifyAll(array('value' => '1|0::0'));
			
			foreach ($this->_post->raw() as $key => $value)
			{
				if (preg_match('/value-(string|text|int|float|enum|bool|color)-(.*)/', $key) === 1)
				{
					list(, $type, $k) = explode("-", $key);
					if (!empty($k))
					{
						$_value = ':NULL';
						if ($value)
						{
							switch ($type)
							{
								case 'string':
								case 'text':
								case 'enum':
								case 'color':
									$_value = $this->_post->toString($key);
									break;
								case 'int':
								case 'bool':
									$_value = $this->_post->toInt($key);
									break;
								case 'float':
									$_value = $this->_post->toFloat($key);
									break;
							}
						}
			
						$pjOptionModel
						->reset()
						->where('foreign_id', $this->getForeignId())
						->where('`key`', $k)
						->limit(1)
						->modifyAll(array('value' => $_value));
					}
				}
			}
			
			$i18n_arr = $this->_post->toI18n('i18n');
			if (!empty($i18n_arr))
			{
				pjMultiLangModel::factory()->updateMultiLang($i18n_arr, $this->getForeignId(), 'pjOption', 'data');
			}
			
			if ($this->_post->check('tab'))
			{
				switch ($this->_post->toInt('tab'))
				{
					case '1':
						$err = 'AO06';
						break;
					case '2':
						$err = 'AO03';
						break;
					case '3':
						$err = 'AO09';
						break;
				}
			}
			pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdminOptions&action=" . $this->_post->toString('next_action') . "&err=$err");
		}
	}

	public function pjActionUpdateTheme()
	{
	$this->setAjax(true);
		
		if (!$this->isXHR())
		{
			self::jsonResponse(array('status' => 'ERR', 'code' => 100, 'text' => 'Missing headers.'));
		}
		
		if(!self::isPost())
		{
			self::jsonResponse(array('status' => 'ERR', 'code' => 101, 'text' => 'HTTP method not allowed.'));
		}
		
		if (!$this->_post->has('theme'))
		{
			self::jsonResponse(array('status' => 'ERR', 'code' => 102, 'text' => 'Missing, empty or invalid parameters.'));
		}
		
		pjOptionModel::factory()
			->where('foreign_id', $this->getForeignId())
			->where('`key`', 'o_theme')
			->limit(1)
			->modifyAll(array('value' => 'theme1|theme2|theme3|theme4|theme5|theme6|theme7|theme8|theme9|theme10::' . $this->_post->toString('theme')));
		
		self::jsonResponse(array('status' => 'OK', 'code' => 200, 'text' => 'Theme has been changed.'));
	}

	public function pjActionNotificationsGetMetaData()
	{
		$this->setAjax(true);
		
		if (!$this->isXHR())
		{
			self::jsonResponse(array('status' => 'ERR', 'code' => 100, 'text' => 'Missing headers.'));
		}
		
		if (!self::isGet())
		{
			self::jsonResponse(array('status' => 'ERR', 'code' => 101, 'text' => 'Invalid request.'));
		}
		
		if (!(isset($this->query['recipient']) && pjValidation::pjActionNotEmpty($this->query['recipient'])))
		{
			self::jsonResponse(array('status' => 'ERR', 'code' => 102, 'text' => 'Missing, empty or invalid parameters.'));
		}
		
		$this->set('arr', pjNotificationModel::factory()
			->where('t1.recipient', $this->query['recipient'])
			->orderBy('t1.id ASC')
			->findAll()
			->getData());
	}
	
	public function pjActionNotificationsGetContent()
	{
		$this->setAjax(true);
		
		if (!$this->isXHR())
		{
			self::jsonResponse(array('status' => 'ERR', 'code' => 100, 'text' => 'Missing headers.'));
		}
		
		if (!self::isGet())
		{
			self::jsonResponse(array('status' => 'ERR', 'code' => 101, 'text' => 'Invalid request.'));
		}
		
		if (!($this->_get->check('recipient') && $this->_get->check('variant') && $this->_get->check('transport'))
			&& pjValidation::pjActionNotEmpty($this->_get->toString('recipient'))
			&& pjValidation::pjActionNotEmpty($this->_get->toString('variant'))
			&& pjValidation::pjActionNotEmpty($this->_get->toString('transport'))
			&& in_array($this->_get->toString('transport'), array('email', 'sms'))
		)
		{
			self::jsonResponse(array('status' => 'ERR', 'code' => 102, 'text' => 'Missing, empty or invalid parameters.'));
		}
		
		$arr = pjNotificationModel::factory()
			->where('t1.recipient', $this->_get->toString('recipient'))
			->where('t1.variant', $this->_get->toString('variant'))
			->where('t1.transport', $this->_get->toString('transport'))
			->limit(1)
			->findAll()
			->getDataIndex(0);
		
		if (!$arr)
		{
			self::jsonResponse(array('status' => 'ERR', 'code' => 103, 'text' => 'Message not found.'));
		}
		
		$arr['i18n'] = pjBaseMultiLangModel::factory()->getMultiLang($this->getForeignId(), 'pjOption');
		$this->set('arr', $arr);
		
		# Check SMS
		$this->set('is_sms_ready', (isset($this->option_arr['plugin_sms_api_key']) && !empty($this->option_arr['plugin_sms_api_key']) ? 1 : 0));
		
		# Get locales
		$locale_arr = pjBaseLocaleModel::factory()
			->select('t1.*, t2.file, t2.title')
			->join('pjBaseLocaleLanguage', 't2.iso=t1.language_iso', 'left')
			->where('t2.file IS NOT NULL')
			->orderBy('t1.sort ASC')
			->findAll()
			->getData();
		
		$lp_arr = array();
		foreach ($locale_arr as $item)
		{
			$lp_arr[$item['id']."_"] = array($item['file'], $item['title']);
		}
		$this->set('lp_arr', $locale_arr);
		$this->set('locale_str', self::jsonEncode($lp_arr));
		$this->set('is_flag_ready', $this->requestAction(array('controller' => 'pjBaseLocale', 'action' => 'pjActionIsFlagReady'), array('return')));
	}
	
	public function pjActionNotificationsSetContent()
	{
		$this->setAjax(true);
		
		if (!$this->isXHR())
		{
			self::jsonResponse(array('status' => 'ERR', 'code' => 100, 'text' => 'Missing headers.'));
		}
		
		if (!self::isPost())
		{
			self::jsonResponse(array('status' => 'ERR', 'code' => 101, 'text' => 'Invalid request.'));
		}
		
		if (!(isset($this->body['id']) && pjValidation::pjActionNumeric($this->body['id'])))
		{
			self::jsonResponse(array('status' => 'ERR', 'code' => 102, 'text' => 'Missing, empty or invalid parameters.'));
		}
		
		$isToggle = $this->_post->check('is_active') && in_array($this->_post->toInt('is_active'), array(1,0));
		$isFormSubmit = $this->_post->check('i18n') && !$this->_post->isEmpty('i18n');
		
		if (!($isToggle xor $isFormSubmit))
		{
			self::jsonResponse(array('status' => 'ERR', 'code' => 103, 'text' => 'Data mismatch.'));
		}
		
		if ($isToggle)
		{
			pjNotificationModel::factory()
				->set('id', $this->_post->toInt('id'))
				->modify(array('is_active' => $this->_post->toInt('is_active')));
		} elseif ($isFormSubmit) {
			pjBaseMultiLangModel::factory()->updateMultiLang($this->_post->toArray('i18n'), $this->getForeignId(), 'pjOption');
		}
		
		self::jsonResponse(array('status' => 'OK', 'code' => 200, 'text' => 'Notification has been updated.'));
	}

	public function pjActionLocationsFees()
	{
		if (!pjAuth::factory()->hasAccess()) {
			$this->sendForbidden();
			return;
		}

		if ($this->_post->check('locations_fees')) {
			pjLocationFeeModel::factory()->eraseAll();
			if ($this->_post->check('locations')) {
				foreach ($this->_post->toArray('locations') as $location) {
					pjLocationFeeModel::factory()->reset()->setAttributes($location)->insert();
				}
			}

			pjUtil::redirect(PJ_INSTALL_URL . "index.php?controller=pjAdminOptions&action=pjActionLocationsFees&err=ALF01");
		}

		$locations = pjLocationModel::factory()
			->select('t1.*, t2.content as name')
			->join('pjMultiLang', 't2.model = "pjLocation" AND t2.foreign_id = t1.id AND t2.field = "name" AND t2.locale = ' . $this->getLocaleId(), 'left')
			->orderBy('t2.content ASC')
			->findAll()
			->getData();

		$this->set('locations', $locations);

		$locationsFees = pjLocationFeeModel::factory()->findAll()->getData();
		$this->set('locationsFees', $locationsFees);

		$this->appendJs('pjAdminOptions.js');
	}

	public function pjActionRequests()
	{
		if (!pjAuth::factory()->hasAccess()) {
			$this->sendForbidden();
			return;
		}

		if ($this->_post->check('save')) {
			pjRequestModel::factory()->eraseAll();
			if ($this->_post->check('requests')) {
				foreach ($this->_post->toArray('requests') as $request) {
					$request['date_from'] = pjDateTime::formatDate($request['date_from'], $this->option_arr['o_date_format']);
					$request['date_to'] = pjDateTime::formatDate($request['date_to'], $this->option_arr['o_date_format']);
					pjRequestModel::factory()->reset()->setAttributes($request)->insert();
				}
			}

			pjUtil::redirect(PJ_INSTALL_URL . "index.php?controller=pjAdminOptions&action=pjActionRequests&err=AOR01");
		}

		$locations = pjLocationModel::factory()
			->select('t1.*, t2.content as name')
			->join('pjMultiLang', 't2.model = "pjLocation" AND t2.foreign_id = t1.id AND t2.field = "name" AND t2.locale = ' . $this->getLocaleId(), 'left')
			->orderBy('t2.content ASC')
			->findAll()
			->getData();

		$this->set('locations', $locations);

		$types = pjTypeModel::factory()
			->select('t1.*, t2.content as name')
			->join('pjMultiLang', 't2.model = "pjType" AND t2.foreign_id = t1.id AND t2.field = "name" AND t2.locale = ' . $this->getLocaleId(), 'left')
			->orderBy('t2.content ASC')
			->findAll()
			->getData();

		$this->set('types', $types);

		$requests = pjRequestModel::factory()->findAll()->getData();
		$this->set('requests', $requests);

		$this->appendCss('datepicker3.css', PJ_THIRD_PARTY_PATH . 'bootstrap_datepicker/');
		$this->appendJs('bootstrap-datepicker.js', PJ_THIRD_PARTY_PATH . 'bootstrap_datepicker/');
		$this->appendJs('pjAdminOptions.js');
	}
	
	public function pjActionModifyPrices()
	{
		if (!pjAuth::factory()->hasAccess()) {
			$this->sendForbidden();
			return;
		}

		if ($this->_post->check('save')) {
			pjModifyPriceModel::factory()->eraseAll();
			pjModifyPriceLocationModel::factory()->eraseAll();
			pjModifyPriceTypeModel::factory()->eraseAll();
			if ($this->_post->check('modify_prices')) {
				foreach ($this->_post->toArray('modify_prices') as $modifyPrice) {
					$modifyPrice['date_from'] = pjDateTime::formatDate($modifyPrice['date_from'], $this->option_arr['o_date_format']);
					$modifyPrice['date_to'] = pjDateTime::formatDate($modifyPrice['date_to'], $this->option_arr['o_date_format']);
					$modifyPriceId = pjModifyPriceModel::factory()->reset()->setAttributes($modifyPrice)->insert()->getInsertId();

					if ($modifyPrice['location_id']) {
						foreach ($modifyPrice['location_id'] as $locationId) {
							pjModifyPriceLocationModel::factory()->reset()->setAttributes(array(
								'modify_price_id' => $modifyPriceId,
								'location_id' => $locationId
							))->insert();
						}
					}

					if ($modifyPrice['type_id']) {
						foreach ($modifyPrice['type_id'] as $typeId) {
							pjModifyPriceTypeModel::factory()->reset()->setAttributes(array(
								'modify_price_id' => $modifyPriceId,
								'type_id' => $typeId
							))->insert();
						}
					}
				}
			}

			pjUtil::redirect(PJ_INSTALL_URL . "index.php?controller=pjAdminOptions&action=pjActionModifyPrices&err=AOMP01");
		}

		$locations = pjLocationModel::factory()
			->select('t1.*, t2.content as name')
			->join('pjMultiLang', 't2.model = "pjLocation" AND t2.foreign_id = t1.id AND t2.field = "name" AND t2.locale = ' . $this->getLocaleId(), 'left')
			->orderBy('t2.content ASC')
			->findAll()
			->getData();
		
		$this->set('locations', $locations);
		
		$types = pjTypeModel::factory()
			->select('t1.*, t2.content as name')
			->join('pjMultiLang', 't2.model = "pjType" AND t2.foreign_id = t1.id AND t2.field = "name" AND t2.locale = ' . $this->getLocaleId(), 'left')
			->orderBy('t2.content ASC')
			->findAll()
			->getData();
		
		$this->set('types', $types);

		$modifyPrices = pjModifyPriceModel::factory()->findAll()->getData();
		if (!empty($modifyPrices)) {
			foreach ($modifyPrices as $k => $modifyPrice) {
				$modifyPrices[$k]['location_id'] = pjModifyPriceLocationModel::factory()->where('modify_price_id', $modifyPrice['id'])->findAll()->getDataPair(null, 'location_id');
				$modifyPrices[$k]['type_id'] = pjModifyPriceTypeModel::factory()->where('modify_price_id', $modifyPrice['id'])->findAll()->getDataPair(null, 'type_id');
			}
		}

		$this->set('modify_prices', $modifyPrices);

		$this->appendCss('css/select2.min.css', PJ_THIRD_PARTY_PATH . 'select2/');
		$this->appendJs('js/select2.full.min.js', PJ_THIRD_PARTY_PATH . 'select2/');

		$this->appendCss('datepicker3.css', PJ_THIRD_PARTY_PATH . 'bootstrap_datepicker/');
		$this->appendJs('bootstrap-datepicker.js', PJ_THIRD_PARTY_PATH . 'bootstrap_datepicker/');
		$this->appendJs('pjAdminOptions.js');
	}
}
?>