var jQuery = jQuery || $.noConflict();
(function ($, undefined) {
	$(function () {
		"use strict";

		var $frmCreateCity = $("#frmCreateCity"),
			$frmUpdateCity = $("#frmUpdateCity"),
			$pjFdFormWrapper = $("#pjFdFormWrapper"),
			multilang = ($.fn.multilang !== undefined),
			dialog = ($.fn.dialog !== undefined),
			validate = ($.fn.validate !== undefined),
			datagrid = ($.fn.datagrid !== undefined),
			locale_id = myLabel.localeId,
			$tr = null;
		
			if (multilang && 'pjCmsLocale' in window) {
				$(".multilang").multilang({
					langs: pjCmsLocale.langs,
					flagPath: pjCmsLocale.flagPath,
					tooltip: "",
					select: function (event, ui) {
						locale_id = ui.index;
					}
				});
			}
				
			if(myLabel.locale_array.length > 0){
			
				for(var i = 0; i < myLabel.locale_array.length ; i++){
				
					var $address_element = $(document).find('#i18n_' + myLabel.locale_array[i] + '_address');
					var $form = $address_element.closest('form');

					//console.log('$form',$form);
					
					if($address_element.length > 0){
						
						var autocomplete_pickup = new google.maps.places.Autocomplete($address_element[0], {
							types: ["geocode"]
						});
						var pickup_field = document.getElementById('i18n_' + myLabel.locale_array[i] + '_address');
						google.maps.event.addDomListener(pickup_field, 'keydown', function(e) { 
						    if (e.keyCode == 13) { 
						        e.preventDefault(); 
						    }
						});

						google.maps.event.addListener(autocomplete_pickup, 'place_changed', function() {
							var place = autocomplete_pickup.getPlace();
							$form.find('input[name="lat"]').val(place.geometry.location.lat());
							$form.find('input[name="lng"]').val(place.geometry.location.lng());
						});
					}
				}
			}
		


		function getCreateForm()
		{
			//alert('fdfd');
			$.get("index.php?controller=pjAdminCities&action=pjActionCreateForm").done(function (data) {
				$pjFdFormWrapper.html(data);
				bindCreateForm();
			});
		}
		if ($pjFdFormWrapper.length > 0 && myLabel.has_create) 
		{
			getCreateForm();
		}
		function highlightLanguage()
		{
			$(".pj-form-langbar-item").removeClass('btn-primary').removeClass('btn-white');
			$(".pj-form-langbar-item").each(function( index ) {
				if($(this).attr('data-index') == myLabel.localeId)
				{
					$(this).addClass('btn-primary');
				}
			});
			$(".pj-multilang-wrap").each(function( index ) {
				if($(this).attr('data-index') == myLabel.localeId)
				{
					$(this).css('display','block');
				}else{
					$(this).css('display','none');
				}
			});
		}
		function bindCreateForm()
		{
			$frmCreateCity = $("#frmCreateCity");
			if ($frmCreateCity.length > 0 && validate) {
				$frmCreateCity.validate({
					invalidHandler: function (event, validator) {
					    $(".pj-multilang-wrap").each(function( index ) {
							if($(this).attr('data-index') == myLabel.localeId)
							{
								locale_id = myLabel.localeId;
								$(this).css('display','block');
							}else{
								$(this).css('display','none');
							}
						});
						$(".pj-form-langbar-item").each(function( index ) {
							if($(this).attr('data-index') == myLabel.localeId)
							{
								locale_id = myLabel.localeId;
								$(this).addClass('btn-primary');
							}else{
								$(this).removeClass('btn-primary');
							}
						});
					},
					ignore: "",
					submitHandler: function(form){
						var ladda_buttons = $(form).find('.ladda-button');
					    if(ladda_buttons.length > 0)
	                    {
	                        var l = ladda_buttons.ladda();
	                        l.ladda('start');
	                    }
					    $.post("index.php?controller=pjAdminCities&action=pjActionCreate", $(form).serialize()).done(function (data) {
					    	l.ladda('stop');
					    	if(data.status == 'OK')
					    	{
					    		getCreateForm();
					    		var content = $grid.datagrid("option", "content"),
									cache = $grid.datagrid("option", "cache");
								$.extend(cache, {
									status: "",
									q: ""
								});
								$grid.datagrid("option", "cache", cache);
								$grid.datagrid("load", "index.php?controller=pjAdminCities&action=pjActionGetCity", "name", "ASC", content.page, content.rowCount);
					    	}else if(data.code == '104'){
					    		swal({
					    			title: "",
									text: data.text,
									type: "warning",
									confirmButtonColor: "#DD6B55",
									confirmButtonText: "OK",
									closeOnConfirm: false,
									showLoaderOnConfirm: false
								}, function () {
									swal.close();
								});
					    	}
						});
						return false;
					}
				});
				highlightLanguage();
			}
		}
		function bindUpdateForm()
		{
			$frmUpdateCity = $("#frmUpdateCity");
			if ($frmUpdateCity.length > 0 && validate) {
				$frmUpdateCity.validate({
					invalidHandler: function (event, validator) {
					    $(".pj-multilang-wrap").each(function( index ) {
							if($(this).attr('data-index') == myLabel.localeId)
							{
								locale_id = myLabel.localeId;
								$(this).css('display','block');
							}else{
								$(this).css('display','none');
							}
						});
						$(".pj-form-langbar-item").each(function( index ) {
							if($(this).attr('data-index') == myLabel.localeId)
							{
								locale_id = myLabel.localeId;
								$(this).addClass('btn-primary');
							}else{
								$(this).removeClass('btn-primary');
							}
						});
					},
					ignore: "",
					submitHandler: function(form){
						var ladda_buttons = $(form).find('.ladda-button');
					    if(ladda_buttons.length > 0)
	                    {
	                        var l = ladda_buttons.ladda();
	                        l.ladda('start');
	                    }
					    $.post("index.php?controller=pjAdminCities&action=pjActionUpdate", $(form).serialize()).done(function (data) {
					    	l.ladda('stop');
					    	if(data.status == 'OK')
					    	{
					    		getCreateForm();
					    		var content = $grid.datagrid("option", "content"),
									cache = $grid.datagrid("option", "cache");
								$.extend(cache, {
									status: "",
									q: ""
								});
								$grid.datagrid("option", "cache", cache);
								$grid.datagrid("load", "index.php?controller=pjAdminCities&action=pjActionGetCity", "name", "ASC", content.page, content.rowCount);
					    	}else if(data.code == '105'){
					    		swal({
					    			title: "",
									text: data.text,
									type: "warning",
									confirmButtonColor: "#DD6B55",
									confirmButtonText: "OK",
									closeOnConfirm: false,
									showLoaderOnConfirm: false
								}, function () {
									swal.close();
								});
					    	}
						});
						return false;
					}
				});
				highlightLanguage();
			}
		}

		var locationTypeMap = {
		    "1": "Airport",
		    "2": "Area",
		    "3": "Train Station"
		};

		if ($("#grid").length > 0 && datagrid) {
			var $buttons = [];
			var $actions = [];
			var $editable = false;
			var $select = false;
			//if (myLabel.has_update) {
				$editable = false;
				$buttons.push({type: "edit", url: "index.php?controller=pjAdminCities&action=pjActionUpdate&id={:id}"});

			//}
			//if (myLabel.has_delete) {
				$buttons.push({type: "delete", url: "index.php?controller=pjAdminCities&action=pjActionDeleteCity&id={:id}"});
			//}
			//if (myLabel.has_delete_bulk) {
				$actions.push({text: myLabel.delete_selected, url: "index.php?controller=pjAdminCities&action=pjActionDeleteCityBulk", render: true, confirmation: myLabel.delete_confirmation});
			//}
			if ($actions.length > 0) {
				$select = {
						field: "id",
						name: "record[]",
						cellClass: 'cell-width-2'
					};
			}
			var $grid = $("#grid").datagrid({
				buttons: $buttons,
				columns: [
						{text: myLabel.name, type: "text", sortable: true, editable: $editable},
						{
							text: myLabel.ltype, 
							type: "text", 
							sortable: true, 
							//editable: $editable,
							renderer: function(value, row) {
				                return locationTypeMap[value] || value;
				            }
						},
						{text: myLabel.lorder, type: "text", sortable: true, editable: $editable},
			          	{text: myLabel.status, type: "toggle", sortable: true, editable: $editable, positiveLabel: myLabel.active, positiveValue: "T", negativeLabel: myLabel.inactive, negativeValue: "F"}
			          	],
				dataUrl: "index.php?controller=pjAdminCities&action=pjActionGetCity",
				dataType: "json",
				fields: ['name', 'location_type','location_order', 'status'],
				paginator: {
					actions: $actions,
					gotoPage: true,
					paginate: true,
					total: true,
					rowCount: true
				},
				saveUrl: "index.php?controller=pjAdminCities&action=pjActionSaveCity&id={:id}",
				select: $select
			});
		}
		
		if(myLabel.trigger_create == 1 && myLabel.has_create)
		{
			getCreateForm();
		}
		$(document).on("click", ".btn-all", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			$(this).addClass("btn-primary active").removeClass("btn-default")
				.siblings(".btn").removeClass("btn-primary active").addClass("btn-default");
			var content = $grid.datagrid("option", "content"),
				cache = $grid.datagrid("option", "cache");
			$.extend(cache, {
				status: "",
				q: ""
			});
			$grid.datagrid("option", "cache", cache);
			$grid.datagrid("load", "index.php?controller=pjAdminCities&action=pjActionGetCity", "name", "ASC", content.page, content.rowCount);
			
		}).on("click", ".btn-filter", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var $this = $(this),
				content = $grid.datagrid("option", "content"),
				cache = $grid.datagrid("option", "cache"),
				obj = {};
			$this.addClass("btn-primary active").removeClass("btn-default")
				.siblings(".btn").removeClass("btn-primary active").addClass("btn-default");
			obj.status = "";
			obj[$this.data("column")] = $this.data("value");
			$.extend(cache, obj);
			$grid.datagrid("option", "cache", cache);
			$grid.datagrid("load", "index.php?controller=pjAdminCities&action=pjActionGetCity", "name", "ASC", content.page, content.rowCount);
			
		}).on("submit", ".frm-filter", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var $this = $(this),
				content = $grid.datagrid("option", "content"),
				cache = $grid.datagrid("option", "cache");
			$.extend(cache, {
				q: $this.find("input[name='q']").val()
			});
			$grid.datagrid("option", "cache", cache);
			$grid.datagrid("load", "index.php?controller=pjAdminCities&action=pjActionGetCity", "name", "ASC", content.page, content.rowCount);
			return false;
		}).on("click", ".pjFdAddCity", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			getCreateForm();
			if($tr != null)
			{
				$tr.find('.pj-table-icon-edit').show();
				$tr.find('.pj-table-icon-delete').show();
				$tr = null;
			}
		}).on("click", ".pjFdBtnCancel", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			if (myLabel.has_create) {
				getCreateForm();
			} else {
				$pjFdFormWrapper.html('');
			}			
			if($tr != null)
			{
				$tr.find('.pj-table-icon-edit').show();
				$tr.find('.pj-table-icon-delete').show();
				$tr = null;
			}
		}).on("click", ".pj-table-icon-edit", function (e) {
			// if (e && e.preventDefault) {
			// 	e.preventDefault();
			// }
			// var $this = $(this);
			// var href = $this.attr('href');
			// $.get(href).done(function (data) {
			// 	$pjFdFormWrapper.html(data);
			// 	bindUpdateForm();
			// 	if($tr != null)
			// 	{
			// 		$tr.find('.pj-table-icon-edit').show();
			// 		$tr.find('.pj-table-icon-delete').show();
			// 		$tr = null;
			// 	}
			// 	$tr = $this.closest("tr");
			// 	$tr.find('.pj-table-icon-edit').hide();
			// 	$tr.find('.pj-table-icon-delete').hide();
			// });
		});
	});
})(jQuery);